/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.adapter;

import io.quarkus.qute.debug.Debugger;
import io.quarkus.qute.debug.DebuggerListener;
import io.quarkus.qute.debug.StoppedEvent;
import io.quarkus.qute.debug.ThreadEvent;
import io.quarkus.qute.debug.agent.DebuggeeAgent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.CompletionsArguments;
import org.eclipse.lsp4j.debug.CompletionsResponse;
import org.eclipse.lsp4j.debug.ContinueArguments;
import org.eclipse.lsp4j.debug.ContinueResponse;
import org.eclipse.lsp4j.debug.DisconnectArguments;
import org.eclipse.lsp4j.debug.EvaluateArguments;
import org.eclipse.lsp4j.debug.EvaluateResponse;
import org.eclipse.lsp4j.debug.ExitedEventArguments;
import org.eclipse.lsp4j.debug.InitializeRequestArguments;
import org.eclipse.lsp4j.debug.NextArguments;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.PauseArguments;
import org.eclipse.lsp4j.debug.ScopesArguments;
import org.eclipse.lsp4j.debug.ScopesResponse;
import org.eclipse.lsp4j.debug.SetBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetExceptionBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetExceptionBreakpointsResponse;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.SourceArguments;
import org.eclipse.lsp4j.debug.SourceBreakpoint;
import org.eclipse.lsp4j.debug.SourceResponse;
import org.eclipse.lsp4j.debug.StackTraceArguments;
import org.eclipse.lsp4j.debug.StackTraceResponse;
import org.eclipse.lsp4j.debug.StepInArguments;
import org.eclipse.lsp4j.debug.StepOutArguments;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.eclipse.lsp4j.debug.TerminateArguments;
import org.eclipse.lsp4j.debug.TerminatedEventArguments;
import org.eclipse.lsp4j.debug.Thread;
import org.eclipse.lsp4j.debug.ThreadEventArguments;
import org.eclipse.lsp4j.debug.ThreadsResponse;
import org.eclipse.lsp4j.debug.VariablesArguments;
import org.eclipse.lsp4j.debug.VariablesResponse;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;

public class DebugServerAdapter
implements IDebugProtocolServer {
    private final Debugger agent;
    private IDebugProtocolClient client;
    private final Map<Integer, Thread> threads = new HashMap<Integer, Thread>();

    public DebugServerAdapter(DebuggeeAgent agent) {
        this.agent = agent;
        agent.addDebuggerListener(new DebuggerListener(){

            @Override
            public void output(OutputEventArguments args) {
                if (DebugServerAdapter.this.client != null) {
                    DebugServerAdapter.this.client.output(args);
                }
            }

            @Override
            public void onThreadChanged(ThreadEvent event) {
                DebugServerAdapter.this.handleThreadChanged(event);
            }

            @Override
            public void onStopped(StoppedEvent event) {
                DebugServerAdapter.this.handleStopped(event);
            }

            @Override
            public void onTerminate() {
                DebugServerAdapter.this.handleTerminate();
            }
        });
    }

    public CompletableFuture<Capabilities> initialize(InitializeRequestArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            Capabilities capabilities = new Capabilities();
            capabilities.setSupportsCompletionsRequest(Boolean.TRUE);
            capabilities.setSupportsConditionalBreakpoints(Boolean.TRUE);
            capabilities.setSupportsEvaluateForHovers(Boolean.TRUE);
            return capabilities;
        });
    }

    public void connect(IDebugProtocolClient client) {
        this.client = client;
        this.agent.setEnabled(true);
    }

    public CompletableFuture<Void> attach(Map<String, Object> args) {
        return CompletableFuture.runAsync(() -> ((IDebugProtocolClient)this.client).initialized());
    }

    public CompletableFuture<SetBreakpointsResponse> setBreakpoints(SetBreakpointsArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            SetBreakpointsResponse response = new SetBreakpointsResponse();
            Source source = args.getSource();
            SourceBreakpoint[] sourceBreakpoints = args.getBreakpoints();
            Breakpoint[] breakpoints = this.agent.setBreakpoints(sourceBreakpoints, source);
            response.setBreakpoints(breakpoints);
            return response;
        });
    }

    public CompletableFuture<SetExceptionBreakpointsResponse> setExceptionBreakpoints(SetExceptionBreakpointsArguments args) {
        return CompletableFuture.supplyAsync(SetExceptionBreakpointsResponse::new);
    }

    public CompletableFuture<ThreadsResponse> threads() {
        return CompletableFuture.supplyAsync(() -> {
            ThreadsResponse response = new ThreadsResponse();
            response.setThreads(this.agent.getThreads());
            return response;
        });
    }

    public CompletableFuture<StackTraceResponse> stackTrace(StackTraceArguments args) {
        return CompletableFuture.supplyAsync(() -> this.agent.getStackFrames(args.getThreadId(), args.getStartFrame(), args.getLevels()));
    }

    public CompletableFuture<ScopesResponse> scopes(ScopesArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            ScopesResponse response = new ScopesResponse();
            int frameId = args.getFrameId();
            response.setScopes(this.agent.getScopes(frameId));
            return response;
        });
    }

    public CompletableFuture<VariablesResponse> variables(VariablesArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            VariablesResponse response = new VariablesResponse();
            int variablesReference = args.getVariablesReference();
            response.setVariables(this.agent.getVariables(variablesReference));
            return response;
        });
    }

    public CompletableFuture<Void> terminate(TerminateArguments args) {
        return CompletableFuture.runAsync(this.agent::terminate);
    }

    public CompletableFuture<Void> disconnect(DisconnectArguments args) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.agent.terminate();
            }
            finally {
                this.agent.setEnabled(false);
            }
        });
    }

    public CompletableFuture<Void> stepIn(StepInArguments args) {
        return CompletableFuture.runAsync(() -> this.agent.stepIn(args.getThreadId()));
    }

    public CompletableFuture<Void> stepOut(StepOutArguments args) {
        return CompletableFuture.runAsync(() -> this.agent.stepOut(args.getThreadId()));
    }

    public CompletableFuture<Void> pause(PauseArguments args) {
        return CompletableFuture.runAsync(() -> this.agent.pause(args.getThreadId()));
    }

    public CompletableFuture<Void> next(NextArguments args) {
        return CompletableFuture.runAsync(() -> this.agent.next(args.getThreadId()));
    }

    public CompletableFuture<ContinueResponse> continue_(ContinueArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            ContinueResponse response = new ContinueResponse();
            int threadId = args.getThreadId();
            if (threadId != 0) {
                response.setAllThreadsContinued(Boolean.FALSE);
                this.agent.resume(threadId);
            } else {
                response.setAllThreadsContinued(Boolean.TRUE);
            }
            return response;
        });
    }

    public CompletableFuture<EvaluateResponse> evaluate(EvaluateArguments args) {
        return this.agent.evaluate(args.getFrameId(), args.getExpression(), args.getContext());
    }

    public CompletableFuture<CompletionsResponse> completions(CompletionsArguments args) {
        return this.agent.completions(args);
    }

    public CompletableFuture<SourceResponse> source(SourceArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            Source source = args.getSource();
            return this.agent.getSourceReference(source != null && source.getSourceReference() != null ? source.getSourceReference().intValue() : args.getSourceReference());
        });
    }

    private void handleStopped(StoppedEvent event) {
        int threadId = event.getThreadId();
        String reason = event.getReason();
        this.sendStopEvent(threadId, reason);
    }

    public void handleThreadChanged(ThreadEvent event) {
        int threadId = event.getThreadId();
        String reason = event.getReason();
        this.sendThreadEvent(threadId, reason);
    }

    private void sendStopEvent(int threadId, String reason) {
        if (this.client == null) {
            return;
        }
        StoppedEventArguments args = new StoppedEventArguments();
        args.setThreadId(Integer.valueOf(threadId));
        args.setReason(reason);
        this.client.stopped(args);
    }

    private void sendThreadEvent(int threadId, String reason) {
        if (this.client == null) {
            return;
        }
        ThreadEventArguments args = new ThreadEventArguments();
        args.setThreadId(threadId);
        args.setReason(reason);
        this.client.thread(args);
    }

    public void handleTerminate() {
        this.sendExitEvent();
    }

    private void sendExitEvent() {
        if (this.client == null) {
            return;
        }
        ExitedEventArguments args = new ExitedEventArguments();
        this.client.exited(args);
        this.client.terminated(new TerminatedEventArguments());
    }
}

