/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.agent.resolvers;

import io.quarkus.qute.Engine;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.debug.agent.RemoteStackFrame;
import io.quarkus.qute.debug.agent.resolvers.DefaultValueResolverCollector;
import io.quarkus.qute.debug.agent.resolvers.ReflectionValueResolverCollector;
import io.quarkus.qute.debug.agent.resolvers.ValueResolverCollector;
import io.quarkus.qute.debug.agent.resolvers.ValueResolverContext;
import java.util.List;

public class ValueResolverRegistry {
    private static final String IO_QUARKUS_QUTE_REFLECTION_VALUE_RESOLVER = "io.quarkus.qute.ReflectionValueResolver";
    private static final ValueResolverRegistry INSTANCE = new ValueResolverRegistry();
    private static final ValueResolverCollector REFLECTION_VALUE_RESOLVER_COLLECTOR = new ReflectionValueResolverCollector();
    private static final ValueResolverCollector DEFAULT_VALUE_RESOLVER_COLLECTOR = new DefaultValueResolverCollector();

    private ValueResolverRegistry() {
    }

    public static ValueResolverRegistry getInstance() {
        return INSTANCE;
    }

    public void fillWithValueResolvers(ValueResolverContext context) {
        Object base = context.getBase();
        RemoteStackFrame stackFrame = context.getStackFrame();
        Engine engine = stackFrame.getEngine();
        EvalContext evalContext = stackFrame.createEvalContext(base);
        List valueResolvers = engine.getValueResolvers();
        for (ValueResolver valueResolver : valueResolvers) {
            ValueResolverCollector collector = this.getCollector(valueResolver);
            if (collector == null || !collector.isApplicable(valueResolver, evalContext)) continue;
            collector.collect(valueResolver, context);
        }
    }

    public void fillWithReflectionValueResolver(ValueResolverContext context) {
        DEFAULT_VALUE_RESOLVER_COLLECTOR.collect(null, context);
    }

    private ValueResolverCollector getCollector(ValueResolver valueResolver) {
        if (ValueResolverRegistry.isReflectionValueResolver(valueResolver)) {
            return REFLECTION_VALUE_RESOLVER_COLLECTOR;
        }
        return DEFAULT_VALUE_RESOLVER_COLLECTOR;
    }

    public static boolean isReflectionValueResolver(ValueResolver valueResolver) {
        String className = valueResolver.getClass().getName();
        return IO_QUARKUS_QUTE_REFLECTION_VALUE_RESOLVER.equals(className);
    }
}

