/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.adapter;

import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.debug.adapter.DebugServerAdapter;
import io.quarkus.qute.debug.agent.DebuggeeAgent;
import io.quarkus.qute.trace.TemplateEvent;
import io.quarkus.qute.trace.TraceListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.lsp4j.debug.launch.DSPLauncher;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;

public class RegisterDebugServerAdapter
implements EngineBuilder.EngineListener {
    private Integer port;
    private Boolean suspend;
    private final Set<Engine> trackedEngines = new HashSet<Engine>();
    private final Set<Engine> notInitializedEngines = new HashSet<Engine>();
    private volatile boolean initialized;
    private volatile DebuggeeAgent agent;
    private volatile ServerSocket serverSocket;
    private Future<Void> launcherFuture;
    private DebugServerAdapter server;
    private final ExecutorService executor = this.createDaemonExecutor();
    private final TraceListener initializeAgentListener = new TraceListener(){

        public void onStartTemplate(TemplateEvent event) {
            RegisterDebugServerAdapter.this.initializeAgent(RegisterDebugServerAdapter.this.getPort(), RegisterDebugServerAdapter.this.isSuspend());
        }
    };

    public RegisterDebugServerAdapter() {
        this(null, null);
    }

    public RegisterDebugServerAdapter(Integer port, Boolean suspend) {
        this.port = port;
        this.suspend = suspend;
    }

    public void engineBuilt(Engine engine) {
        this.trackedEngines.add(engine);
        if (this.initialized) {
            this.agent.track(engine);
            return;
        }
        Integer port = this.getPort();
        if (port == null) {
            return;
        }
        this.agent = this.createAgentIfNeeded();
        this.initializeAgent(port, this.isSuspend());
        this.agent.track(engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DebuggeeAgent createAgentIfNeeded() {
        if (this.agent == null) {
            RegisterDebugServerAdapter registerDebugServerAdapter = this;
            synchronized (registerDebugServerAdapter) {
                if (this.agent == null) {
                    this.agent = new DebuggeeAgent();
                    this.server = new DebugServerAdapter(this.agent);
                    this.trackedEngines.forEach(this.agent::track);
                }
            }
        }
        return this.agent;
    }

    public Integer getPort() {
        if (this.port != null) {
            return this.port;
        }
        this.port = RegisterDebugServerAdapter.doGetPort();
        return this.port;
    }

    private static Integer doGetPort() {
        String portStr = RegisterDebugServerAdapter.getPropertyValue("quteDebugPort");
        if (portStr == null || portStr.isBlank()) {
            return null;
        }
        try {
            return Integer.parseInt(portStr);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isSuspend() {
        if (this.suspend != null) {
            return this.suspend;
        }
        this.suspend = this.doIsSuspend();
        return this.suspend;
    }

    private boolean doIsSuspend() {
        String suspend = RegisterDebugServerAdapter.getPropertyValue("quteDebugSuspend");
        if (suspend == null || suspend.isBlank()) {
            return false;
        }
        try {
            return Boolean.parseBoolean(suspend);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String getPropertyValue(String name) {
        String value = System.getenv(name);
        if (value == null || value.isBlank()) {
            value = System.getProperty(name);
        }
        return value;
    }

    private synchronized void initializeAgent(int port, boolean suspend) {
        if (this.initialized) {
            return;
        }
        if (suspend) {
            this.initializeAgentBlocking(port, true);
        } else {
            this.executor.execute(() -> this.initializeAgentBlocking(port, false));
        }
    }

    private synchronized void initializeAgentBlocking(int port, boolean suspend) {
        if (this.serverSocket != null) {
            return;
        }
        try {
            this.serverSocket = new ServerSocket(port);
            RegisterDebugServerAdapter.log("Qute debugger server listening on port " + this.serverSocket.getLocalPort());
            if (suspend) {
                RegisterDebugServerAdapter.log("Waiting for Qute debugger client to connect (suspend mode)...");
                Socket client = this.serverSocket.accept();
                RegisterDebugServerAdapter.log("Qute debugger client connected (suspend mode)!");
                this.setupLauncher(client, true);
            } else {
                this.executor.execute(() -> {
                    while (this.serverSocket != null && !this.serverSocket.isClosed()) {
                        try {
                            RegisterDebugServerAdapter.log("Waiting for a new Qute debugger client...");
                            Socket client = this.serverSocket.accept();
                            RegisterDebugServerAdapter.log("Qute debugger client connected");
                            this.setupLauncher(client, false);
                            this.trackedEngines.forEach(engine -> this.agent.track((Engine)engine));
                        }
                        catch (IOException e) {
                            if (this.serverSocket == null || this.serverSocket.isClosed()) continue;
                            e.printStackTrace();
                        }
                    }
                });
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.dispose()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        if (this.launcherFuture != null && !this.launcherFuture.isDone()) {
            this.launcherFuture.cancel(true);
        }
        RegisterDebugServerAdapter.log("Shutdown hook: closing server socket.");
        try {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.serverSocket = null;
        }
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                RegisterDebugServerAdapter.log("Executor did not terminate in the specified time.");
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.agent.terminate();
    }

    public void reset() {
        if (this.agent != null) {
            this.agent.reset();
        }
        this.trackedEngines.clear();
        if (!this.notInitializedEngines.isEmpty()) {
            this.notInitializedEngines.forEach(engine -> {
                if (engine.getTraceManager() != null) {
                    engine.removeTraceListener(this.initializeAgentListener);
                }
            });
            this.notInitializedEngines.clear();
        }
    }

    private void setupLauncher(Socket client, boolean suspend) throws IOException {
        if (this.launcherFuture != null && !this.launcherFuture.isDone()) {
            this.launcherFuture.cancel(true);
        }
        Launcher launcher = DSPLauncher.createServerLauncher((IDebugProtocolServer)this.server, (InputStream)client.getInputStream(), (OutputStream)client.getOutputStream(), (ExecutorService)this.executor, null);
        IDebugProtocolClient clientProxy = (IDebugProtocolClient)launcher.getRemoteProxy();
        this.server.connect(clientProxy);
        this.launcherFuture = launcher.startListening();
        if (!this.notInitializedEngines.isEmpty()) {
            this.notInitializedEngines.forEach(engine -> {
                if (engine.getTraceManager() != null) {
                    engine.removeTraceListener(this.initializeAgentListener);
                }
            });
            this.notInitializedEngines.clear();
        }
        if (suspend) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private ExecutorService createDaemonExecutor() {
        return Executors.newCachedThreadPool(r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("dap-daemon-thread");
            return t;
        });
    }

    private static void log(String message) {
        System.out.println(message);
    }
}

