/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Futures;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.LiteralSupport;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public class IncludeSectionHelper
implements SectionHelper {
    static final String DEFAULT_NAME = "$default$";
    private static final String TEMPLATE = "template";
    private final Supplier<Template> templateSupplier;
    private final Map<String, SectionBlock> extendingBlocks;
    private final Map<String, Expression> parameters;

    public IncludeSectionHelper(Supplier<Template> templateSupplier, Map<String, SectionBlock> extendingBlocks, Map<String, Expression> parameters) {
        this.templateSupplier = templateSupplier;
        this.extendingBlocks = extendingBlocks;
        this.parameters = parameters;
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        if (this.parameters.isEmpty()) {
            return ((TemplateImpl)this.templateSupplier.get()).root.resolve(context.resolutionContext().createChild(null, this.extendingBlocks));
        }
        CompletableFuture<ResultNode> result = new CompletableFuture<ResultNode>();
        Futures.evaluateParams(this.parameters, context.resolutionContext()).whenComplete((evaluatedParams, t1) -> {
            if (t1 != null) {
                result.completeExceptionally((Throwable)t1);
            } else {
                try {
                    TemplateImpl tagTemplate = (TemplateImpl)this.templateSupplier.get();
                    tagTemplate.root.resolve(context.resolutionContext().createChild(Mapper.wrap(evaluatedParams), this.extendingBlocks)).whenComplete((resultNode, t2) -> {
                        if (t2 != null) {
                            result.completeExceptionally((Throwable)t2);
                        } else {
                            result.complete((ResultNode)resultNode);
                        }
                    });
                }
                catch (Throwable e) {
                    result.completeExceptionally(e);
                }
            }
        });
        return result;
    }

    public static class Factory
    implements SectionHelperFactory<IncludeSectionHelper> {
        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of("include");
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter(IncludeSectionHelper.TEMPLATE).build();
        }

        @Override
        public boolean treatUnknownSectionsAsBlocks() {
            return true;
        }

        @Override
        public Scope initializeBlock(Scope outerScope, SectionHelperFactory.BlockInfo block) {
            if (block.getLabel().equals("$main")) {
                for (Map.Entry<String, String> entry : block.getParameters().entrySet()) {
                    if (entry.getKey().equals(IncludeSectionHelper.TEMPLATE)) continue;
                    block.addExpression(entry.getKey(), entry.getValue());
                }
                return outerScope;
            }
            return outerScope;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IncludeSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            void var4_9;
            Map<String, Expression> params;
            HashMap<String, SectionBlock> extendingBlocks = new HashMap<String, SectionBlock>();
            for (SectionBlock sectionBlock : context.getBlocks()) {
                String string = sectionBlock.id.equals("$main") ? IncludeSectionHelper.DEFAULT_NAME : sectionBlock.label;
                if (extendingBlocks.put(string, sectionBlock) == null) continue;
                throw new TemplateException(context.getBlocks().get((int)0).origin, String.format("Multiple blocks define the content for the insert section '%s' in template %s", string, sectionBlock.origin.getTemplateId()));
            }
            if (context.getParameters().size() == 1) {
                params = Collections.emptyMap();
            } else {
                params = new HashMap();
                for (Map.Entry<String, String> entry : context.getParameters().entrySet()) {
                    if (entry.getKey().equals(IncludeSectionHelper.TEMPLATE)) continue;
                    params.put(entry.getKey(), context.getExpression(entry.getKey()));
                }
            }
            String string = context.getParameter(IncludeSectionHelper.TEMPLATE);
            if (LiteralSupport.isStringLiteralSeparator(string.charAt(0))) {
                String string2 = string.substring(1, string.length() - 1);
            }
            void var5_13 = var4_9;
            final Engine engine = context.getEngine();
            return new IncludeSectionHelper(new Supplier<Template>((String)var5_13){
                final /* synthetic */ String val$templateId;
                {
                    this.val$templateId = string;
                }

                @Override
                public Template get() {
                    Template template = engine.getTemplate(this.val$templateId);
                    if (template == null) {
                        throw new TemplateException("Template not found: " + this.val$templateId);
                    }
                    return template;
                }
            }, extendingBlocks, params);
        }
    }
}

