/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.tls.runtime.config.TlsConfigUtils;
import io.quarkus.websockets.next.UserData;
import io.quarkus.websockets.next.WebSocketClientConnection;
import io.quarkus.websockets.next.WebSocketClientException;
import io.quarkus.websockets.next.runtime.ClientConnectionManager;
import io.quarkus.websockets.next.runtime.Codecs;
import io.quarkus.websockets.next.runtime.config.WebSocketsClientRuntimeConfig;
import io.vertx.core.Vertx;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketClientOptions;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.impl.ContextImpl;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

abstract class WebSocketConnectorBase<THIS extends WebSocketConnectorBase<THIS>> {
    protected static final Pattern PATH_PARAM_PATTERN = Pattern.compile("\\{[a-zA-Z0-9_]+\\}");
    private static final Logger LOG = Logger.getLogger(WebSocketConnectorBase.class);
    protected URI baseUri;
    protected WebSocketConnectOptions customWebSocketConnectOptions;
    protected WebSocketClientOptions customWebSocketClientOptions;
    protected final Map<String, String> pathParams;
    protected final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    protected final Set<String> subprotocols = new HashSet<String>();
    protected String path;
    protected Set<String> pathParamNames;
    protected final Map<String, Object> userData;
    protected String tlsConfigurationName;
    protected final Vertx vertx;
    protected final Codecs codecs;
    protected final ClientConnectionManager connectionManager;
    protected final WebSocketsClientRuntimeConfig config;
    protected final TlsConfigurationRegistry tlsConfigurationRegistry;

    WebSocketConnectorBase(Vertx vertx, Codecs codecs, ClientConnectionManager connectionManager, WebSocketsClientRuntimeConfig config, TlsConfigurationRegistry tlsConfigurationRegistry) {
        this.pathParams = new HashMap<String, String>();
        this.vertx = vertx;
        this.codecs = codecs;
        this.connectionManager = connectionManager;
        this.config = config;
        this.tlsConfigurationRegistry = tlsConfigurationRegistry;
        this.path = "";
        this.pathParamNames = Set.of();
        this.userData = new HashMap<String, Object>();
        this.customWebSocketConnectOptions = null;
        this.customWebSocketClientOptions = null;
    }

    public THIS baseUri(URI baseUri) {
        if (!this.isSecure(baseUri) && !this.isNotSecure(baseUri)) {
            throw new IllegalArgumentException(String.format("[%s] is not a valid scheme in the base URI %s", baseUri.getScheme(), baseUri));
        }
        this.baseUri = Objects.requireNonNull(baseUri);
        return this.self();
    }

    public THIS tlsConfigurationName(String tlsConfigurationName) {
        this.tlsConfigurationName = Objects.requireNonNull(tlsConfigurationName);
        return this.self();
    }

    public THIS addHeader(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        List<String> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.headers.put(name, values);
        }
        values.add(value);
        return this.self();
    }

    public THIS pathParam(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        if (!this.pathParamNames.contains(name)) {
            throw new IllegalArgumentException(String.format("[%s] is not a valid path parameter in the path %s", name, this.path));
        }
        this.pathParams.put(name, value);
        return this.self();
    }

    public THIS addSubprotocol(String value) {
        this.subprotocols.add(Objects.requireNonNull(value));
        return this.self();
    }

    public <VALUE> THIS userData(UserData.TypedKey<VALUE> key, VALUE value) {
        this.userData.put(key.value(), value);
        return this.self();
    }

    void setPath(String path) {
        this.path = Objects.requireNonNull(path);
        this.pathParamNames = this.getPathParamNames(path);
    }

    protected THIS self() {
        return (THIS)this;
    }

    Set<String> getPathParamNames(String path) {
        HashSet<String> names = new HashSet<String>();
        Matcher m = PATH_PARAM_PATTERN.matcher(path);
        while (m.find()) {
            String match = m.group();
            String paramName = match.substring(1, match.length() - 1);
            names.add(paramName);
        }
        return names;
    }

    String replacePathParameters(String path) {
        if (path.isEmpty()) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        Matcher m = PATH_PARAM_PATTERN.matcher(path);
        while (m.find()) {
            String match = m.group();
            String paramName = match.substring(1, match.length() - 1);
            String val = this.pathParams.get(paramName);
            if (val == null) {
                throw new WebSocketClientException("Unable to obtain the path param for: " + paramName);
            }
            m.appendReplacement(sb, URLEncoder.encode(val, StandardCharsets.UTF_8));
        }
        m.appendTail(sb);
        return path.startsWith("/") ? sb.toString() : "/" + sb.toString();
    }

    protected WebSocketClientOptions populateClientOptions() {
        Optional maybeTlsConfiguration;
        WebSocketClientOptions clientOptions = this.customWebSocketClientOptions != null ? new WebSocketClientOptions(this.customWebSocketClientOptions) : new WebSocketClientOptions();
        if (this.config.offerPerMessageCompression()) {
            clientOptions.setTryUsePerMessageCompression(true);
            if (this.config.compressionLevel().isPresent()) {
                clientOptions.setCompressionLevel(this.config.compressionLevel().getAsInt());
            }
        }
        if (this.config.maxMessageSize().isPresent()) {
            clientOptions.setMaxMessageSize(this.config.maxMessageSize().getAsInt());
        }
        if (this.config.maxFrameSize().isPresent()) {
            clientOptions.setMaxFrameSize(this.config.maxFrameSize().getAsInt());
        }
        if (this.config.connectionIdleTimeout().isPresent()) {
            Duration timeout = this.config.connectionIdleTimeout().get();
            if (timeout.toMillis() > Integer.MAX_VALUE) {
                clientOptions.setIdleTimeoutUnit(TimeUnit.SECONDS);
                clientOptions.setIdleTimeout((int)timeout.toSeconds());
            } else {
                clientOptions.setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
                clientOptions.setIdleTimeout((int)timeout.toMillis());
            }
        }
        if (this.config.connectionClosingTimeout().isPresent()) {
            long timeoutSeconds = this.config.connectionClosingTimeout().get().toSeconds();
            clientOptions.setClosingTimeout(timeoutSeconds > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeoutSeconds);
        }
        if ((maybeTlsConfiguration = TlsConfiguration.from((TlsConfigurationRegistry)this.tlsConfigurationRegistry, Optional.ofNullable(this.tlsConfigurationName))).isEmpty()) {
            maybeTlsConfiguration = TlsConfiguration.from((TlsConfigurationRegistry)this.tlsConfigurationRegistry, this.config.tlsConfigurationName());
        }
        if (maybeTlsConfiguration.isPresent()) {
            TlsConfigUtils.configure((WebSocketClientOptions)clientOptions, (TlsConfiguration)((TlsConfiguration)maybeTlsConfiguration.get()));
        }
        return clientOptions;
    }

    protected WebSocketConnectOptions newConnectOptions(URI serverEndpointUri) {
        WebSocketConnectOptions connectOptions = this.customWebSocketConnectOptions != null ? new WebSocketConnectOptions(this.customWebSocketConnectOptions) : new WebSocketConnectOptions();
        connectOptions.setSsl(Boolean.valueOf(this.isSecure(serverEndpointUri))).setHost(serverEndpointUri.getHost());
        if (serverEndpointUri.getPort() != -1) {
            connectOptions.setPort(Integer.valueOf(serverEndpointUri.getPort()));
        } else if (this.isSecure(serverEndpointUri)) {
            connectOptions.setPort(Integer.valueOf(443));
        }
        return connectOptions;
    }

    protected boolean isNotSecure(URI uri) {
        return "http".equals(uri.getScheme()) || "ws".equals(uri.getScheme());
    }

    protected boolean isSecure(URI uri) {
        return "https".equals(uri.getScheme()) || "wss".equals(uri.getScheme());
    }

    Consumer<WebSocketClientConnection> newCleanupConsumer(final WebSocketClient client, final ContextImpl context) {
        return new Consumer<WebSocketClientConnection>(){

            @Override
            public void accept(WebSocketClientConnection conn) {
                try {
                    client.close();
                    LOG.debugf("Client closed for connection %s", (Object)conn.id());
                }
                catch (Throwable e) {
                    LOG.errorf(e, "Unable to close the client for connection %s", (Object)conn.id());
                }
                try {
                    context.close();
                    LOG.debugf("Context closed for connection %s", (Object)conn.id());
                }
                catch (Throwable e) {
                    LOG.errorf(e, "Unable to close the context for connection %s", (Object)conn.id());
                }
            }
        };
    }

    public THIS customizeOptions(BiConsumer<WebSocketConnectOptions, WebSocketClientOptions> customizer) {
        Objects.requireNonNull(customizer, "Options customizer must not be null");
        if (this.customWebSocketClientOptions == null) {
            this.customWebSocketClientOptions = new WebSocketClientOptions();
        }
        if (this.customWebSocketConnectOptions == null) {
            this.customWebSocketConnectOptions = new WebSocketConnectOptions();
        }
        customizer.accept(this.customWebSocketConnectOptions, this.customWebSocketClientOptions);
        return this.self();
    }

    record WebSocketOpen(Consumer<WebSocketClientConnection> cleanup, WebSocket websocket) {
    }
}

