/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.vertx.core.buffer.Buffer;

public interface Sender {
    @CheckReturnValue
    public Uni<Void> sendText(String var1);

    default public void sendTextAndAwait(String message) {
        this.sendText((Object)message).await().indefinitely();
    }

    @CheckReturnValue
    public <M> Uni<Void> sendText(M var1);

    default public <M> void sendTextAndAwait(M message) {
        this.sendText(message).await().indefinitely();
    }

    @CheckReturnValue
    public Uni<Void> sendBinary(Buffer var1);

    default public void sendBinaryAndAwait(Buffer message) {
        this.sendBinary(message).await().indefinitely();
    }

    @CheckReturnValue
    default public Uni<Void> sendBinary(byte[] message) {
        return this.sendBinary(Buffer.buffer((byte[])message));
    }

    default public void sendBinaryAndAwait(byte[] message) {
        this.sendBinary(message).await().indefinitely();
    }

    @CheckReturnValue
    public Uni<Void> sendPing(Buffer var1);

    default public void sendPingAndAwait(Buffer data) {
        this.sendPing(data).await().indefinitely();
    }

    @CheckReturnValue
    public Uni<Void> sendPong(Buffer var1);

    default public void sendPongAndAwait(Buffer data) {
        this.sendPong(data).await().indefinitely();
    }
}

