/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.virtual.threads.VirtualThreadsRecorder;
import io.quarkus.websockets.next.InboundProcessingMode;
import io.quarkus.websockets.next.runtime.Codecs;
import io.quarkus.websockets.next.runtime.ConcurrencyLimiter;
import io.quarkus.websockets.next.runtime.ContextSupport;
import io.quarkus.websockets.next.runtime.SecuritySupport;
import io.quarkus.websockets.next.runtime.WebSocketConnectionBase;
import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.telemetry.ErrorInterceptor;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Singleton;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.logging.Logger;

public abstract class WebSocketEndpointBase
implements WebSocketEndpoint {
    private static final Logger LOG = Logger.getLogger(WebSocketEndpointBase.class);
    public final WebSocketConnectionBase connection;
    protected final Codecs codecs;
    private final ErrorInterceptor errorInterceptor;
    private final ConcurrencyLimiter limiter;
    private final ArcContainer container;
    private final ContextSupport contextSupport;
    private final SecuritySupport securitySupport;
    private final InjectableBean<?> bean;
    private final Object beanInstance;

    public WebSocketEndpointBase(WebSocketConnectionBase connection, Codecs codecs, ContextSupport contextSupport, SecuritySupport securitySupport, ErrorInterceptor errorInterceptor) {
        this.connection = connection;
        this.codecs = codecs;
        this.limiter = this.inboundProcessingMode() == InboundProcessingMode.SERIAL ? new ConcurrencyLimiter(connection) : null;
        this.container = Arc.container();
        this.contextSupport = contextSupport;
        this.securitySupport = securitySupport;
        this.errorInterceptor = errorInterceptor;
        InjectableBean bean = this.container.bean(this.beanIdentifier());
        if (bean.getScope().equals(ApplicationScoped.class) || bean.getScope().equals(Singleton.class)) {
            this.bean = null;
            this.beanInstance = this.container.instance(bean).get();
        } else {
            this.bean = bean;
            this.beanInstance = null;
        }
    }

    @Override
    public Future<Void> onOpen() {
        return this.execute(null, this.onOpenExecutionModel(), this::doOnOpen, false);
    }

    @Override
    public Future<Void> onTextMessage(Object message) {
        return this.execute(message, this.onTextMessageExecutionModel(), this::doOnTextMessage, false);
    }

    @Override
    public Future<Void> onBinaryMessage(Object message) {
        return this.execute(message, this.onBinaryMessageExecutionModel(), this::doOnBinaryMessage, false);
    }

    @Override
    public Future<Void> onPingMessage(Buffer message) {
        return this.execute(message, this.onPingMessageExecutionModel(), this::doOnPingMessage, false);
    }

    @Override
    public Future<Void> onPongMessage(Buffer message) {
        return this.execute(message, this.onPongMessageExecutionModel(), this::doOnPongMessage, false);
    }

    @Override
    public Future<Void> onClose() {
        return this.execute(null, this.onCloseExecutionModel(), this::doOnClose, true);
    }

    private <M> Future<Void> execute(final M message, final WebSocketEndpoint.ExecutionModel executionModel, final Function<M, Uni<Void>> action, final boolean terminateSession) {
        if (executionModel == WebSocketEndpoint.ExecutionModel.NONE) {
            if (terminateSession) {
                this.contextSupport.startSession();
                this.contextSupport.endSession();
            }
            return Future.succeededFuture();
        }
        Promise promise = Promise.promise();
        final Context context = Vertx.currentContext();
        if (this.limiter != null) {
            final ConcurrencyLimiter.PromiseComplete complete = this.limiter.newComplete((Promise<Void>)promise);
            this.limiter.run(context, new Runnable(){

                @Override
                public void run() {
                    WebSocketEndpointBase.this.doExecute(context, message, executionModel, action, terminateSession, complete::complete, complete::failure);
                }
            });
        } else {
            this.doExecute(context, message, executionModel, action, terminateSession, () -> ((Promise)promise).complete(), arg_0 -> ((Promise)promise).fail(arg_0));
        }
        return promise.future();
    }

    private <M> void doExecute(Context context, final M message, WebSocketEndpoint.ExecutionModel executionModel, final Function<M, Uni<Void>> action, final boolean terminateSession, Runnable onComplete, Consumer<? super Throwable> onFailure) {
        Handler<Void> contextSupportEnd;
        Handler<Void> handler = contextSupportEnd = executionModel.isBlocking() ? new Handler<Void>(){

            public void handle(Void event) {
                WebSocketEndpointBase.this.contextSupport.end(terminateSession);
            }
        } : null;
        if (executionModel == WebSocketEndpoint.ExecutionModel.VIRTUAL_THREAD) {
            VirtualThreadsRecorder.getCurrent().execute(new Runnable(){
                final /* synthetic */ Handler val$contextSupportEnd;
                final /* synthetic */ Runnable val$onComplete;
                final /* synthetic */ Consumer val$onFailure;
                {
                    this.val$contextSupportEnd = handler;
                    this.val$onComplete = runnable;
                    this.val$onFailure = consumer;
                }

                @Override
                public void run() {
                    Context context = Vertx.currentContext();
                    WebSocketEndpointBase.this.contextSupport.start();
                    WebSocketEndpointBase.this.securitySupport.start();
                    ((Uni)action.apply(message)).subscribe().with(v -> {
                        context.runOnContext(this.val$contextSupportEnd);
                        this.val$onComplete.run();
                    }, t -> {
                        context.runOnContext(this.val$contextSupportEnd);
                        this.val$onFailure.accept(t);
                    });
                }
            });
        } else if (executionModel == WebSocketEndpoint.ExecutionModel.WORKER_THREAD) {
            context.executeBlocking((Callable)new Callable<Void>(){
                final /* synthetic */ Handler val$contextSupportEnd;
                final /* synthetic */ Runnable val$onComplete;
                final /* synthetic */ Consumer val$onFailure;
                {
                    this.val$contextSupportEnd = handler;
                    this.val$onComplete = runnable;
                    this.val$onFailure = consumer;
                }

                @Override
                public Void call() {
                    Context context = Vertx.currentContext();
                    WebSocketEndpointBase.this.contextSupport.start();
                    WebSocketEndpointBase.this.securitySupport.start();
                    ((Uni)action.apply(message)).subscribe().with(v -> {
                        context.runOnContext(this.val$contextSupportEnd);
                        this.val$onComplete.run();
                    }, t -> {
                        context.runOnContext(this.val$contextSupportEnd);
                        this.val$onFailure.accept(t);
                    });
                    return null;
                }
            }, false);
        } else {
            this.contextSupport.start();
            this.securitySupport.start();
            action.apply(message).subscribe().with(v -> {
                this.contextSupport.end(terminateSession);
                onComplete.run();
            }, t -> {
                this.contextSupport.end(terminateSession);
                onFailure.accept((Throwable)t);
            });
        }
    }

    public Uni<Void> doErrorExecute(final Throwable throwable, final WebSocketEndpoint.ExecutionModel executionModel, final Function<Throwable, Uni<Void>> action) {
        final Promise promise = Promise.promise();
        ContextSupport.createNewDuplicatedContext(Vertx.currentContext(), this.connection).runOnContext((Handler)new Handler<Void>(){

            public void handle(Void event) {
                Handler<Void> contextSupportEnd = new Handler<Void>(){

                    public void handle(Void event) {
                        WebSocketEndpointBase.this.contextSupport.end(false);
                    }
                };
                if (executionModel == WebSocketEndpoint.ExecutionModel.VIRTUAL_THREAD) {
                    VirtualThreadsRecorder.getCurrent().execute(new Runnable(){
                        final /* synthetic */ Handler val$contextSupportEnd;
                        {
                            this.val$contextSupportEnd = handler;
                        }

                        @Override
                        public void run() {
                            Context context = Vertx.currentContext();
                            WebSocketEndpointBase.this.contextSupport.start();
                            WebSocketEndpointBase.this.securitySupport.start();
                            ((Uni)action.apply(throwable)).subscribe().with(v -> {
                                context.runOnContext(this.val$contextSupportEnd);
                                promise.complete();
                            }, t -> {
                                context.runOnContext(this.val$contextSupportEnd);
                                promise.fail(t);
                            });
                        }
                    });
                } else if (executionModel == WebSocketEndpoint.ExecutionModel.WORKER_THREAD) {
                    Vertx.currentContext().executeBlocking((Callable)new Callable<Void>(){
                        final /* synthetic */ Handler val$contextSupportEnd;
                        {
                            this.val$contextSupportEnd = handler;
                        }

                        @Override
                        public Void call() {
                            Context context = Vertx.currentContext();
                            WebSocketEndpointBase.this.contextSupport.start();
                            WebSocketEndpointBase.this.securitySupport.start();
                            ((Uni)action.apply(throwable)).subscribe().with(v -> {
                                context.runOnContext(this.val$contextSupportEnd);
                                promise.complete();
                            }, t -> {
                                context.runOnContext(this.val$contextSupportEnd);
                                promise.fail(t);
                            });
                            return null;
                        }
                    }, false);
                } else {
                    Vertx.currentContext().runOnContext((Handler)new Handler<Void>(){
                        final /* synthetic */ Handler val$contextSupportEnd;
                        {
                            this.val$contextSupportEnd = handler;
                        }

                        public void handle(Void event) {
                            Context context = Vertx.currentContext();
                            WebSocketEndpointBase.this.contextSupport.start();
                            WebSocketEndpointBase.this.securitySupport.start();
                            ((Uni)action.apply(throwable)).subscribe().with(v -> {
                                context.runOnContext(this.val$contextSupportEnd);
                                promise.complete();
                            }, t -> {
                                context.runOnContext(this.val$contextSupportEnd);
                                promise.fail(t);
                            });
                        }
                    });
                }
            }
        });
        return Uni.createFrom().completionStage(() -> promise.future().toCompletionStage());
    }

    public Object beanInstance() {
        return this.beanInstance != null ? this.beanInstance : this.container.instance(this.bean).get();
    }

    public Object beanInstance(String identifier) {
        return this.container.instance(this.container.bean(identifier)).get();
    }

    protected Uni<Void> doOnOpen(Object message) {
        return Uni.createFrom().voidItem();
    }

    protected Uni<Void> doOnTextMessage(Object message) {
        return Uni.createFrom().voidItem();
    }

    protected Uni<Void> doOnBinaryMessage(Object message) {
        return Uni.createFrom().voidItem();
    }

    protected Uni<Void> doOnPingMessage(Buffer message) {
        return Uni.createFrom().voidItem();
    }

    protected Uni<Void> doOnPongMessage(Buffer message) {
        return Uni.createFrom().voidItem();
    }

    protected Uni<Void> doOnClose(Object message) {
        return Uni.createFrom().voidItem();
    }

    @Override
    public Uni<Void> doOnError(Throwable t) {
        this.interceptError(t);
        return Uni.createFrom().failure(t);
    }

    public void interceptError(Throwable t) {
        if (this.errorInterceptor != null) {
            this.errorInterceptor.intercept(t);
        }
    }

    public Object decodeText(Type type, String value, Class<?> codecBeanClass) {
        return this.codecs.textDecode(type, value, codecBeanClass);
    }

    public String encodeText(Object value, Class<?> codecBeanClass) {
        if (value == null) {
            return null;
        }
        return this.codecs.textEncode(value, codecBeanClass);
    }

    public Object decodeBinary(Type type, Buffer value, Class<?> codecBeanClass) {
        return this.codecs.binaryDecode(type, value, codecBeanClass);
    }

    public Buffer encodeBinary(Object value, Class<?> codecBeanClass) {
        if (value == null) {
            return null;
        }
        return this.codecs.binaryEncode(value, codecBeanClass);
    }

    public Uni<Void> sendText(String message, boolean broadcast) {
        return broadcast ? this.connection.broadcast().sendText(message) : this.connection.sendText(message);
    }

    public Uni<Void> multiText(Multi<Object> multi, Function<? super Object, Uni<?>> action) {
        multi.onItem().call(action).onFailure().recoverWithMulti(t -> this.doOnError((Throwable)t).toMulti()).subscribe().with(m -> LOG.debugf("Multi >> text message: %s", (Object)this.connection), t -> LOG.errorf(t, "Unable to send text message from Multi: %s ", (Object)this.connection));
        return Uni.createFrom().voidItem();
    }

    public Uni<Void> sendBinary(Buffer message, boolean broadcast) {
        return broadcast ? this.connection.broadcast().sendBinary(message) : this.connection.sendBinary(message);
    }

    public Uni<Void> multiBinary(Multi<Object> multi, Function<? super Object, Uni<?>> action) {
        multi.onItem().call(action).onFailure().recoverWithMulti(t -> this.doOnError((Throwable)t).toMulti()).subscribe().with(m -> LOG.debugf("Multi >> binary message: %s", (Object)this.connection), t -> LOG.errorf(t, "Unable to send binary message from Multi: %s ", (Object)this.connection));
        return Uni.createFrom().voidItem();
    }
}

