/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.websockets.next.HandshakeRequest;
import io.quarkus.websockets.next.WebSocketClientConnection;
import io.quarkus.websockets.next.WebSocketConnection;
import io.quarkus.websockets.next.runtime.WebSocketConnectionBase;
import io.quarkus.websockets.next.runtime.config.WebSocketsClientRuntimeConfig;
import io.quarkus.websockets.next.runtime.config.WebSocketsServerRuntimeConfig;
import io.vertx.core.buffer.Buffer;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

class TrafficLogger {
    private static final Logger LOG = Logger.getLogger((String)"io.quarkus.websockets.next.traffic");
    private final Type type;
    private final int textPayloadLimit;

    static TrafficLogger forClient(WebSocketsClientRuntimeConfig config) {
        return config.trafficLogging().enabled() ? new TrafficLogger(Type.CLIENT, config.trafficLogging().textPayloadLimit()) : null;
    }

    static TrafficLogger forServer(WebSocketsServerRuntimeConfig config) {
        return config.trafficLogging().enabled() ? new TrafficLogger(Type.SERVER, config.trafficLogging().textPayloadLimit()) : null;
    }

    private TrafficLogger(Type type, int textPayloadLimit) {
        this.type = type;
        this.textPayloadLimit = textPayloadLimit;
    }

    void connectionOpened(WebSocketConnectionBase connection) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("%s connection opened: %s, Connection[%s], Handshake headers[%s]", new Object[]{this.typeToString(), connection.handshakeRequest().path(), this.connectionToString(connection), this.headersToString(connection.handshakeRequest())});
        }
    }

    void textMessageReceived(WebSocketConnectionBase connection, String payload) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("%s received text message, Connection[%s], Payload: \n%s", (Object)this.typeToString(), (Object)this.connectionToString(connection), (Object)this.payloadToString(payload));
        }
    }

    void textMessageSent(WebSocketConnectionBase connection, String payload) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("%s sent text message, Connection[%s], Payload: \n%s", (Object)this.typeToString(), (Object)this.connectionToString(connection), (Object)this.payloadToString(payload));
        }
    }

    void binaryMessageReceived(WebSocketConnectionBase connection, Buffer payload) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("%s received binary message, Connection[%s], Payload[%s bytes]", (Object)this.typeToString(), (Object)this.connectionToString(connection), (Object)payload.length());
        }
    }

    void binaryMessageSent(WebSocketConnectionBase connection, Buffer payload) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("%s sent binary message, Connection[%s], Payload[%s bytes]", (Object)this.typeToString(), (Object)this.connectionToString(connection), (Object)payload.length());
        }
    }

    void connectionClosed(WebSocketConnectionBase connection) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("%s connection closed, Connection[%s], %s", (Object)this.typeToString(), (Object)this.connectionToString(connection), (Object)connection.closeReason());
        }
    }

    private String payloadToString(String payload) {
        if (payload == null || payload.isBlank()) {
            return "n/a";
        }
        if (this.textPayloadLimit < 0 || payload.length() <= this.textPayloadLimit) {
            return payload;
        }
        return payload.substring(0, payload.length()) + "...";
    }

    private String headersToString(HandshakeRequest request) {
        Map<String, List<String>> headers = request.headers();
        if (headers.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, List<String>> e : headers.entrySet()) {
            for (String value : e.getValue()) {
                builder.append(" ").append(e.getKey()).append("=").append(value);
            }
        }
        return builder.toString();
    }

    private String typeToString() {
        return this.type == Type.SERVER ? "[server]" : "[client]";
    }

    private String connectionToString(WebSocketConnectionBase connection) {
        StringBuilder builder = new StringBuilder();
        if (connection instanceof WebSocketConnection) {
            builder.append("endpointId=").append(((WebSocketConnection)((Object)connection)).endpointId());
        } else {
            builder.append("clientId=").append(((WebSocketClientConnection)((Object)connection)).clientId());
        }
        builder.append(", id=").append(connection.id());
        return builder.toString();
    }

    static enum Type {
        SERVER,
        CLIENT;

    }
}

