/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime.telemetry;

import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.spi.telemetry.WebSocketMetricsInterceptorProducer;
import io.quarkus.websockets.next.runtime.telemetry.ForwardingWebSocketEndpoint;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;

final class MetricsForwardingWebSocketEndpoint
extends ForwardingWebSocketEndpoint {
    private final WebSocketMetricsInterceptorProducer.WebSocketMetricsInterceptor interceptor;
    private final String path;

    MetricsForwardingWebSocketEndpoint(WebSocketEndpoint delegate, WebSocketMetricsInterceptorProducer.WebSocketMetricsInterceptor interceptor, String path) {
        super(delegate);
        this.interceptor = interceptor;
        this.path = path;
    }

    @Override
    public Future<Void> onTextMessage(Object message) {
        this.addMetricsIfMessageIsString(message);
        return this.delegate.onTextMessage(message);
    }

    @Override
    public Future<Void> onBinaryMessage(Object message) {
        this.addMetricsIfMessageIsBuffer(message);
        return this.delegate.onBinaryMessage(message);
    }

    @Override
    public Object decodeTextMultiItem(Object message) {
        this.addMetricsIfMessageIsString(message);
        return this.delegate.decodeTextMultiItem(message);
    }

    @Override
    public Object decodeBinaryMultiItem(Object message) {
        this.addMetricsIfMessageIsBuffer(message);
        return this.delegate.decodeBinaryMultiItem(message);
    }

    @Override
    public Future<Void> onClose() {
        this.interceptor.onConnectionClosed(this.path);
        return this.delegate.onClose();
    }

    private void addMetricsIfMessageIsString(Object message) {
        if (message instanceof String) {
            String stringMessage = (String)message;
            this.interceptor.onMessageReceived(stringMessage.getBytes(), this.path);
        }
    }

    private void addMetricsIfMessageIsBuffer(Object message) {
        if (message instanceof Buffer) {
            Buffer bufferMessage = (Buffer)message;
            this.interceptor.onMessageReceived(bufferMessage.getBytes(), this.path);
        }
    }
}

