/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.jboss.logging.Logger;

public final class WebSocketHeaderPropagationHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(WebSocketHeaderPropagationHandler.class);
    private static final String QUARKUS_HTTP_UPGRADE_PROTOCOL = "quarkus-http-upgrade";
    private static final String HEADER_SEPARATOR = "#";

    public void handle(RoutingContext routingContext) {
        String webSocketProtocols = routingContext.request().headers().get("Sec-WebSocket-Protocol");
        if (webSocketProtocols != null && webSocketProtocols.contains(QUARKUS_HTTP_UPGRADE_PROTOCOL)) {
            routingContext.request().headers().remove("Sec-WebSocket-Protocol");
            StringBuilder otherProtocols = null;
            for (String protocol : webSocketProtocols.split(",")) {
                if ((protocol = protocol.trim()).startsWith(QUARKUS_HTTP_UPGRADE_PROTOCOL)) {
                    String[] headerNameToValue = (protocol = URLDecoder.decode(protocol, StandardCharsets.UTF_8)).split(HEADER_SEPARATOR);
                    if (headerNameToValue.length != 3) {
                        WebSocketHeaderPropagationHandler.failRequest(routingContext, "Quarkus header format is incorrect. Expected format is: quarkus-http-upgrade#header-name#header-value");
                        return;
                    }
                    routingContext.request().headers().add(headerNameToValue[1], headerNameToValue[2]);
                    continue;
                }
                if (otherProtocols == null) {
                    otherProtocols = new StringBuilder(protocol);
                    continue;
                }
                otherProtocols.append(",").append(protocol);
            }
            if (otherProtocols == null) {
                WebSocketHeaderPropagationHandler.failRequest(routingContext, "WebSocket opening handshake header '%s' only contains '%s' subprotocol.\nClient expects that the WebSocket server agreed to serve exactly one of offered subprotocols.\nPlease add one of protocols configured with the 'quarkus.websockets-next.server.supported-subprotocols' configuration property.\n".formatted("Sec-WebSocket-Protocol", QUARKUS_HTTP_UPGRADE_PROTOCOL));
                return;
            }
            routingContext.request().headers().add((CharSequence)"Sec-WebSocket-Protocol", otherProtocols);
        }
        routingContext.next();
    }

    private static void failRequest(RoutingContext routingContext, String exceptionMessage) {
        LOG.error((Object)exceptionMessage);
        routingContext.fail(500, (Throwable)new IllegalArgumentException(exceptionMessage));
    }
}

