/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.websockets.next.TextMessageCodec;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Singleton
@Priority(value=0)
public class JsonTextMessageCodec
implements TextMessageCodec<Object> {
    private final ConcurrentMap<Type, JavaType> types = new ConcurrentHashMap<Type, JavaType>();
    @Inject
    ObjectMapper mapper;

    @Override
    public String encode(Object value) {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Object decode(Type type, String value) {
        try {
            return this.mapper.readValue(value, this.types.computeIfAbsent(type, this::computeJavaType));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    private JavaType computeJavaType(Type type) {
        return this.mapper.getTypeFactory().constructType(type);
    }

    @Override
    public boolean supports(Type type) {
        return true;
    }
}

