/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next;

import io.quarkus.websockets.next.BlockingSender;
import io.quarkus.websockets.next.CloseReason;
import io.quarkus.websockets.next.HandshakeRequest;
import io.quarkus.websockets.next.Sender;
import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.Uni;
import java.time.Instant;
import java.util.Set;
import java.util.function.Predicate;

@Experimental(value="This API is experimental and may change in the future")
public interface WebSocketConnection
extends Sender,
BlockingSender {
    public String id();

    public String endpointId();

    public String pathParam(String var1);

    public BroadcastSender broadcast();

    public Set<WebSocketConnection> getOpenConnections();

    public boolean isSecure();

    public boolean isClosed();

    public CloseReason closeReason();

    default public boolean isOpen() {
        return !this.isClosed();
    }

    @CheckReturnValue
    default public Uni<Void> close() {
        return this.close(CloseReason.NORMAL);
    }

    public Uni<Void> close(CloseReason var1);

    default public void closeAndAwait() {
        this.close().await().indefinitely();
    }

    default public void closeAndAwait(CloseReason reason) {
        this.close(reason).await().indefinitely();
    }

    public HandshakeRequest handshakeRequest();

    public String subprotocol();

    public Instant creationTime();

    public static interface BroadcastSender
    extends Sender,
    BlockingSender {
        public BroadcastSender filter(Predicate<WebSocketConnection> var1);
    }
}

