/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.websockets.next.Closed;
import io.quarkus.websockets.next.Open;
import io.quarkus.websockets.next.OpenConnections;
import io.quarkus.websockets.next.WebSocketConnection;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.event.Event;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

@Singleton
public class ConnectionManager
implements OpenConnections {
    private static final Logger LOG = Logger.getLogger(ConnectionManager.class);
    private final ConcurrentMap<String, Set<WebSocketConnection>> endpointToConnections = new ConcurrentHashMap<String, Set<WebSocketConnection>>();
    private final List<ConnectionListener> listeners = new CopyOnWriteArrayList<ConnectionListener>();
    private final Event<WebSocketConnection> openEvent;
    private final Event<WebSocketConnection> closedEvent;

    ConnectionManager(@Open Event<WebSocketConnection> openEvent, @Closed Event<WebSocketConnection> closedEvent) {
        ArcContainer container = Arc.container();
        this.openEvent = container.resolveObserverMethods(WebSocketConnection.class, new Annotation[]{Open.Literal.INSTANCE}).isEmpty() ? null : openEvent;
        this.closedEvent = container.resolveObserverMethods(WebSocketConnection.class, new Annotation[]{Closed.Literal.INSTANCE}).isEmpty() ? null : closedEvent;
    }

    @Override
    public Iterator<WebSocketConnection> iterator() {
        return this.stream().iterator();
    }

    @Override
    public Stream<WebSocketConnection> stream() {
        return this.endpointToConnections.values().stream().flatMap(Collection::stream).filter(WebSocketConnection::isOpen);
    }

    void add(String endpoint, WebSocketConnection connection) {
        LOG.debugf("Add connection: %s", (Object)connection);
        if (this.endpointToConnections.computeIfAbsent(endpoint, e -> ConcurrentHashMap.newKeySet()).add(connection)) {
            if (this.openEvent != null) {
                this.openEvent.fireAsync((Object)connection);
            }
            if (!this.listeners.isEmpty()) {
                for (ConnectionListener listener : this.listeners) {
                    try {
                        listener.connectionAdded(endpoint, connection);
                    }
                    catch (Exception e2) {
                        LOG.warnf("Unable to call listener#connectionAdded() on [%s]: %s", listener.getClass(), (Object)e2.toString());
                    }
                }
            }
        }
    }

    void remove(String endpoint, WebSocketConnection connection) {
        LOG.debugf("Remove connection: %s", (Object)connection);
        Set connections = (Set)this.endpointToConnections.get(endpoint);
        if (connections != null && connections.remove(connection)) {
            if (this.closedEvent != null) {
                this.closedEvent.fireAsync((Object)connection);
            }
            if (!this.listeners.isEmpty()) {
                for (ConnectionListener listener : this.listeners) {
                    try {
                        listener.connectionRemoved(endpoint, connection.id());
                    }
                    catch (Exception e) {
                        LOG.warnf("Unable to call listener#connectionRemoved() on [%s]: %s", listener.getClass(), (Object)e.toString());
                    }
                }
            }
        }
    }

    public Set<WebSocketConnection> getConnections(String endpoint) {
        Set ret = (Set)this.endpointToConnections.get(endpoint);
        if (ret == null) {
            return Set.of();
        }
        return ret;
    }

    public void addListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    @PreDestroy
    void destroy() {
        this.endpointToConnections.clear();
    }

    public static interface ConnectionListener {
        public void connectionAdded(String var1, WebSocketConnection var2);

        public void connectionRemoved(String var1, String var2);
    }
}

