/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next;

import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.HttpServerRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public interface HttpUpgradeCheck {
    public Uni<CheckResult> perform(HttpUpgradeContext var1);

    default public boolean appliesTo(String endpointId) {
        return true;
    }

    public static final class CheckResult {
        private static final CheckResult PERMIT_UPGRADE = new CheckResult(true, null, Map.of());
        private final boolean upgradePermitted;
        private final int httpResponseCode;
        private final Map<String, List<String>> responseHeaders;

        private CheckResult(boolean upgradePermitted, Integer httpResponseCode, Map<String, List<String>> responseHeaders) {
            this.upgradePermitted = upgradePermitted;
            this.httpResponseCode = httpResponseCode == null ? 500 : httpResponseCode;
            this.responseHeaders = CheckResult.toUnmodifiableMap(responseHeaders);
        }

        public boolean isUpgradePermitted() {
            return this.upgradePermitted;
        }

        public int getHttpResponseCode() {
            return this.httpResponseCode;
        }

        public Map<String, List<String>> getResponseHeaders() {
            return this.responseHeaders;
        }

        public CheckResult withHeaders(Map<String, List<String>> responseHeaders) {
            if (responseHeaders == null || responseHeaders.isEmpty()) {
                return this;
            }
            HashMap<String, List<String>> newHeaders = new HashMap<String, List<String>>(responseHeaders);
            this.responseHeaders.forEach((k, v) -> newHeaders.put((String)k, CheckResult.merge(v, (List)newHeaders.get(k))));
            return new CheckResult(this.upgradePermitted, this.httpResponseCode, newHeaders);
        }

        public static Uni<CheckResult> rejectUpgrade(Integer httpResponseCode, Map<String, List<String>> responseHeaders) {
            return Uni.createFrom().item((Object)CheckResult.rejectUpgradeSync(httpResponseCode, responseHeaders));
        }

        public static Uni<CheckResult> rejectUpgrade(Integer httpResponseCode) {
            return CheckResult.rejectUpgrade(httpResponseCode, null);
        }

        public static CheckResult rejectUpgradeSync(Integer httpResponseCode) {
            return CheckResult.rejectUpgradeSync(httpResponseCode, null);
        }

        public static CheckResult rejectUpgradeSync(Integer httpResponseCode, Map<String, List<String>> responseHeaders) {
            return new CheckResult(false, httpResponseCode, responseHeaders);
        }

        public static Uni<CheckResult> permitUpgrade(Map<String, List<String>> responseHeaders) {
            return Uni.createFrom().item((Object)CheckResult.permitUpgradeSync(responseHeaders));
        }

        public static CheckResult permitUpgradeSync(Map<String, List<String>> responseHeaders) {
            return new CheckResult(true, null, responseHeaders);
        }

        public static Uni<CheckResult> permitUpgrade() {
            return Uni.createFrom().item((Object)CheckResult.permitUpgradeSync());
        }

        public static CheckResult permitUpgradeSync() {
            return PERMIT_UPGRADE;
        }

        private static List<String> merge(List<String> a, List<String> b) {
            if (b == null || b.isEmpty()) {
                return a;
            }
            return Stream.concat(a.stream(), b.stream()).toList();
        }

        private static Map<String, List<String>> toUnmodifiableMap(Map<String, List<String>> responseHeaders) {
            if (responseHeaders == null || responseHeaders.isEmpty()) {
                return Map.of();
            }
            HashMap<String, List<String>> mutableMap = new HashMap<String, List<String>>(responseHeaders);
            mutableMap.replaceAll((k, v) -> List.copyOf(v));
            return Map.copyOf(mutableMap);
        }
    }

    public record HttpUpgradeContext(HttpServerRequest httpRequest, SecurityIdentity securityIdentity, String endpointId) {
    }
}

