/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.webjar.locator.deployment;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.webjar.locator.runtime.WebJarLocatorRecorder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class WebJarLocatorStandaloneBuildStep {
    private static final String WEBJARS_PREFIX = "META-INF/resources/webjars";
    private static final Logger log = Logger.getLogger((String)WebJarLocatorStandaloneBuildStep.class.getName());

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void findWebjarsAndCreateHandler(HttpBuildTimeConfig httpConfig, BuildProducer<FeatureBuildItem> feature, BuildProducer<RouteBuildItem> routes, CurateOutcomeBuildItem curateOutcome, WebJarLocatorRecorder recorder) throws Exception {
        List providers = QuarkusClassLoader.getElements((String)WEBJARS_PREFIX, (boolean)false);
        Map webjarNameToVersionMap = Collections.emptyMap();
        if (!providers.isEmpty()) {
            HashMap<ArtifactKey, ClassPathElement> webJarKeys = new HashMap<ArtifactKey, ClassPathElement>(providers.size());
            for (ClassPathElement provider : providers) {
                if (provider.getDependencyKey() == null || !provider.isRuntime()) {
                    log.warn((Object)("webjars content found in " + String.valueOf(provider.getRoot()) + " won't be available. Please, report this issue."));
                    continue;
                }
                webJarKeys.put(provider.getDependencyKey(), provider);
            }
            if (!webJarKeys.isEmpty()) {
                HashMap webjarMap = new HashMap(webJarKeys.size());
                for (ResolvedDependency dep : curateOutcome.getApplicationModel().getDependencies()) {
                    ClassPathElement provider;
                    if (!dep.isRuntimeCp() || (provider = (ClassPathElement)webJarKeys.get(dep.getKey())) == null) continue;
                    provider.apply(tree -> {
                        Path nameDir;
                        Path webjarsDir = tree.getPath(WEBJARS_PREFIX);
                        try (Stream<Path> webjarsDirPaths = Files.list(webjarsDir);){
                            nameDir = webjarsDirPaths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findFirst().get();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                        if (nameDir == null) {
                            log.warn((Object)("Failed to determine the name for webjars included in " + String.valueOf(tree.getOriginalTree().getRoots())));
                            return null;
                        }
                        String version = Files.isDirectory(nameDir.resolve(dep.getVersion()), new LinkOption[0]) ? dep.getVersion() : null;
                        webjarMap.put(nameDir.getFileName().toString(), version);
                        return null;
                    });
                }
                webjarNameToVersionMap = webjarMap;
            }
        }
        if (!webjarNameToVersionMap.isEmpty()) {
            String rootPath = httpConfig.rootPath;
            String webjarRootPath = rootPath.endsWith("/") ? rootPath + "webjars/" : rootPath + "/webjars/";
            feature.produce((BuildItem)new FeatureBuildItem(Feature.WEBJARS_LOCATOR));
            routes.produce((BuildItem)RouteBuildItem.builder().route("/webjars/*").handler(recorder.getHandler(webjarRootPath, webjarNameToVersionMap)).build());
        } else {
            log.warn((Object)"No WebJars were found in the project. Requests to the /webjars/ path will always return 404 (Not Found)");
        }
    }
}

