/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.webdependency.locator.deployment.devui;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.webdependency.locator.deployment.ImportMapBuildItem;
import io.quarkus.webdependency.locator.deployment.devui.WebDependencyLibrariesBuildItem;
import io.quarkus.webdependency.locator.deployment.devui.WebDependencyLibrary;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class WebDependencyLocatorDevUIProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    public void createPages(BuildProducer<CardPageBuildItem> cardPageProducer, List<WebDependencyLibrariesBuildItem> webDependencyLibrariesBuildItems, Optional<ImportMapBuildItem> importMapBuildItem) {
        ArrayList<WebDependencyLibrary> webDependencyLibraries = new ArrayList<WebDependencyLibrary>();
        for (WebDependencyLibrariesBuildItem webDependencyLibrariesBuildItem : webDependencyLibrariesBuildItems) {
            webDependencyLibraries.addAll(webDependencyLibrariesBuildItem.getWebDependencyLibraries());
        }
        CardPageBuildItem cardPageBuildItem = new CardPageBuildItem();
        if (!webDependencyLibraries.isEmpty()) {
            cardPageBuildItem.addBuildTimeData("webDependencyLibraries", webDependencyLibraries);
            cardPageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().componentLink("qwc-web-dependency-locator-libraries.js").title("Web libraries")).icon("font-awesome-solid:folder-tree")).staticLabel(String.valueOf(webDependencyLibraries.size())));
            if (importMapBuildItem.isPresent()) {
                cardPageBuildItem.addBuildTimeData("importMap", (Object)importMapBuildItem.get().getImportMap());
                cardPageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().componentLink("qwc-web-dependency-locator-importmap.js").title("Import Map")).icon("font-awesome-solid:diagram-project"));
            }
        }
        cardPageProducer.produce((BuildItem)cardPageBuildItem);
    }
}

