/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.core.quarkus37;

import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class SyncMavenCompilerAnnotationProcessorVersion
extends Recipe {
    private final MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Annotation processor groupId", description="The groupId of the annotation processor.", example="org.hibernate.orm", required=true)
    private final String groupId;
    @Option(displayName="Annotation processor artifactId", description="The artifactId of the annotation processor.", example="hibernate-jpamodelgen", required=true)
    private final String artifactId;

    public String getDisplayName() {
        return "Sync Maven Compiler plugin annotation processor version with the one provided by the BOM";
    }

    public String getDescription() {
        return "Sync Maven Compiler plugin annotation processor version with the one provided by the BOM.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Optional<Xml.Tag> annotationProcessorPathCandidate;
                Optional annotationProcessorPathsWrapper;
                Optional configuration;
                Xml.Tag mavenCompilerPluginTag = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (this.isPluginTag("org.apache.maven.plugins", "maven-compiler-plugin") && (configuration = mavenCompilerPluginTag.getChild("configuration")).isPresent() && (annotationProcessorPathsWrapper = ((Xml.Tag)configuration.get()).getChild("annotationProcessorPaths")).isPresent() && (annotationProcessorPathCandidate = ((Xml.Tag)annotationProcessorPathsWrapper.get()).getChildren().stream().filter(t -> SyncMavenCompilerAnnotationProcessorVersion.this.groupId.equals(t.getChildValue("groupId").orElse(null)) && SyncMavenCompilerAnnotationProcessorVersion.this.artifactId.equals(t.getChildValue("artifactId").orElse(null))).findFirst()).isPresent()) {
                    Xml.Tag annotationProcessorPath = annotationProcessorPathCandidate.get();
                    String newVersion = this.getManagedVersion(SyncMavenCompilerAnnotationProcessorVersion.this.groupId, SyncMavenCompilerAnnotationProcessorVersion.this.artifactId);
                    if (newVersion != null) {
                        Optional versionTag = annotationProcessorPath.getChild("version");
                        if (!versionTag.isPresent()) {
                            Xml.Tag newVersionTag = Xml.Tag.build((String)("<version>" + newVersion + "</version>"));
                            mavenCompilerPluginTag = AddToTagVisitor.addToTag((Xml.Tag)mavenCompilerPluginTag, (Xml.Tag)annotationProcessorPath, (Xml.Tag)newVersionTag, (Cursor)this.getCursor().getParent());
                        } else {
                            mavenCompilerPluginTag = this.changeChildTagValue(mavenCompilerPluginTag, annotationProcessorPath, "version", newVersion, ctx);
                        }
                    }
                }
                return mavenCompilerPluginTag;
            }

            private Xml.Tag changeChildTagValue(Xml.Tag parentScope, Xml.Tag tag, String childTagName, String newValue, ExecutionContext ctx) {
                Optional childTag = tag.getChild(childTagName);
                if (childTag.isPresent() && !newValue.equals(((Xml.Tag)childTag.get()).getValue().orElse(null))) {
                    return (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)childTag.get(), newValue).visitNonNull((Tree)parentScope, (Object)ctx);
                }
                return parentScope;
            }

            private String getManagedVersion(String groupId, String artifactId) {
                MavenResolutionResult result = this.getResolutionResult();
                for (ResolvedManagedDependency managedDependency : result.getPom().getDependencyManagement()) {
                    if (!groupId.equals(managedDependency.getGroupId()) || !artifactId.equals(managedDependency.getArtifactId())) continue;
                    return managedDependency.getVersion();
                }
                return null;
            }
        };
    }

    @ConstructorProperties(value={"groupId", "artifactId"})
    @Generated
    public SyncMavenCompilerAnnotationProcessorVersion(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @NonNull
    @Generated
    public String toString() {
        return "SyncMavenCompilerAnnotationProcessorVersion(metadataFailures=" + this.getMetadataFailures() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SyncMavenCompilerAnnotationProcessorVersion)) {
            return false;
        }
        SyncMavenCompilerAnnotationProcessorVersion other = (SyncMavenCompilerAnnotationProcessorVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SyncMavenCompilerAnnotationProcessorVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        return result;
    }
}

