/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.core.quarkus30;

import io.quarkus.updates.core.quarkus30.AdjustApplicationPropertiesWithJakarta;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class AdjustApplicationYamlWithJakarta
extends Recipe {
    public String getDisplayName() {
        return "Adjust application.yaml for jakarta.* packages";
    }

    public String getDescription() {
        return "Adjust application.yaml for jakarta.* packages";
    }

    public TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new HasSourcePath("**/application*.y*ml");
    }

    public YamlVisitor<ExecutionContext> getVisitor() {
        return new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml.Mapping.Entry e = super.visitMappingEntry(entry, (Object)ctx);
                Yaml.Scalar updatedValue = AdjustApplicationYamlWithJakarta.this.updateValue(e.getValue());
                if (updatedValue != null) {
                    e = e.withValue((Yaml.Block)updatedValue);
                }
                return e;
            }
        };
    }

    @Nullable
    private Yaml.Scalar updateValue(Yaml.Block value) {
        if (!(value instanceof Yaml.Scalar)) {
            return null;
        }
        Yaml.Scalar scalar = (Yaml.Scalar)value;
        String oldValue = scalar.getValue();
        if (StringUtils.isNullOrEmpty((String)oldValue)) {
            return null;
        }
        String newValue = oldValue;
        for (String jakartaPackage : AdjustApplicationPropertiesWithJakarta.JAKARTA_PACKAGES) {
            newValue = newValue.replace(jakartaPackage + ".", jakartaPackage.replace("javax.", "jakarta.") + ".");
        }
        if (oldValue.equals(newValue)) {
            return null;
        }
        return scalar.withValue(newValue);
    }

    public String toString() {
        return "AdjustApplicationYamlWithJakarta()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdjustApplicationYamlWithJakarta)) {
            return false;
        }
        AdjustApplicationYamlWithJakarta other = (AdjustApplicationYamlWithJakarta)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdjustApplicationYamlWithJakarta;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

