/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.camel30.yaml;

import io.quarkus.updates.camel30.yaml.CamelQuarkusYamlVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.format.IndentsVisitor;
import org.openrewrite.yaml.style.IndentsStyle;
import org.openrewrite.yaml.tree.Yaml;

public final class CamelQuarkusYamlRouteConfigurationSequenceRecipe
extends Recipe {
    private static JsonPathMatcher MATCHER_ROUTE_CONFIGURATION = new JsonPathMatcher("$.route-configuration");
    private static JsonPathMatcher MATCHER_ROUTE_CONFIGURATION_ON_EXCEPTION = new JsonPathMatcher("$.route-configuration.on-exception");

    public String getDisplayName() {
        return "Camel Yaml changes regardinhg route-configuration children";
    }

    public String getDescription() {
        return "Camel YAML changes. route-configuration children sequence is replaced with  mappingEntry (with special migration of \"on-exception\").";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new CamelQuarkusYamlVisitor(){
            private Yaml.Sequence sequenceToReplace;
            private boolean indentRegistered = false;

            @Override
            void clearLocalCache() {
                this.sequenceToReplace = null;
            }

            public Yaml.Sequence visitSequence(Yaml.Sequence sequence, ExecutionContext context) {
                Yaml.Sequence s = super.visitSequence(sequence, (Object)context);
                if (new JsonPathMatcher("$.route-configuration").matches(this.getCursor().getParent())) {
                    this.sequenceToReplace = s;
                }
                return s;
            }

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext context) {
                Yaml.Mapping.Entry e = super.visitMappingEntry(entry, (Object)context);
                if (e.getValue() == this.sequenceToReplace) {
                    ArrayList entries = new ArrayList();
                    for (Yaml.Sequence.Entry sEntry : this.sequenceToReplace.getEntries()) {
                        if (!(sEntry.getBlock() instanceof Yaml.Mapping)) continue;
                        ((Yaml.Mapping)sEntry.getBlock()).getEntries().forEach(y -> {
                            if ("on-exception".equals(y.getKey().getValue())) {
                                Yaml.Sequence newSequence = this.sequenceToReplace.copyPaste();
                                List filteredEntries = newSequence.getEntries().stream().filter(se -> ((Yaml.Mapping)se.getBlock()).getEntries().stream().filter(me -> "on-exception".equals(me.getKey().getValue())).findFirst().isPresent()).collect(Collectors.toList());
                                entries.add(y.withValue((Yaml.Block)newSequence.withEntries(filteredEntries)).withPrefix("\n"));
                            } else {
                                entries.add(y.withPrefix("\n"));
                            }
                        });
                    }
                    Yaml.Mapping.Entry resultr = e.withValue((Yaml.Block)new Yaml.Mapping(Tree.randomId(), this.sequenceToReplace.getMarkers(), this.sequenceToReplace.getOpeningBracketPrefix(), entries, null, null));
                    if (!this.indentRegistered) {
                        this.indentRegistered = true;
                        this.doAfterVisit((TreeVisitor)new IndentsVisitor(new IndentsStyle(2), null));
                    }
                    return resultr;
                }
                return e;
            }
        };
    }

    public String toString() {
        return "CamelQuarkusYamlRouteConfigurationSequenceRecipe()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CamelQuarkusYamlRouteConfigurationSequenceRecipe)) {
            return false;
        }
        CamelQuarkusYamlRouteConfigurationSequenceRecipe other = (CamelQuarkusYamlRouteConfigurationSequenceRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof CamelQuarkusYamlRouteConfigurationSequenceRecipe;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

