/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.camel30.java;

import io.quarkus.updates.camel30.AbstractCamelQuarkusJavaVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangePackage;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public final class CamelHttpRecipe
extends Recipe {
    private static final String SET_CREDENTIALS = "org.apache.http.impl.client.BasicCredentialsProvider setCredentials(..)";
    private static final String SCOPE_ANY = "AuthScope.ANY";

    public String getDisplayName() {
        return "Camel Http Extension changes";
    }

    public String getDescription() {
        return "Camel Http Extension changes.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AbstractCamelQuarkusJavaVisitor(){

            @Override
            protected J.Import doVisitImport(J.Import _import, ExecutionContext context) {
                this.doAfterVisit((Recipe)new ChangePackage("org.apache.http.HttpHost", "org.apache.hc.core5.http.HttpHost", null));
                this.doAfterVisit((Recipe)new ChangePackage("org.apache.http.client.protocol.HttpClientContext", "org.apache.hc.client5.http.protocol.HttpClientContext", null));
                this.doAfterVisit((Recipe)new ChangePackage("org.apache.http.impl.client", "org.apache.hc.client5.http.impl.auth", null));
                this.doAfterVisit((Recipe)new ChangePackage("org.apache.http.protocol.HttpContext", "org.apache.hc.core5.http.protocol.HttpContext", null));
                this.doAfterVisit((Recipe)new ChangePackage("org.apache.http", "org.apache.hc.client5.http", null));
                return super.doVisitImport(_import, context);
            }

            @Override
            protected J.FieldAccess doVisitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext context) {
                J.FieldAccess f = super.doVisitFieldAccess(fieldAccess, context);
                if ("ANY".equals(f.getSimpleName()) && "org.apache.http.auth.AuthScope".equals(f.getType().toString())) {
                    JavaTemplate.Builder templateBuilder = JavaTemplate.builder(() -> (this).getCursor(), (String)"new AuthScope(null, -1)").imports(new String[]{"org.apache.hc.client5.http.auth.AuthScope"});
                    J.NewClass nc = (J.NewClass)f.withTemplate((SourceTemplate)templateBuilder.build(), f.getCoordinates().replace(), new Object[0]).withPrefix(f.getPrefix());
                    this.getCursor().putMessage("authScopeNewClass", (Object)nc);
                }
                return f;
            }

            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext context) {
                return super.visitNewClass(newClass, (Object)context);
            }

            @Nullable
            public J postVisit(J tree, ExecutionContext context) {
                J j = (J)super.postVisit((Tree)tree, (Object)context);
                J.NewClass newClass = (J.NewClass)this.getCursor().getMessage("authScopeNewClass");
                if (newClass != null) {
                    return newClass;
                }
                return j;
            }
        };
    }

    public String toString() {
        return "CamelHttpRecipe()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CamelHttpRecipe)) {
            return false;
        }
        CamelHttpRecipe other = (CamelHttpRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof CamelHttpRecipe;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

