/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.core.quarkus37;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.tree.Xml;

public final class AddMavenCompilerAnnotationProcessor
extends Recipe {
    @Option(displayName="Annotation processor groupId", description="The groupId of the annotation processor.", example="org.hibernate.orm", required=true)
    private final String groupId;
    @Option(displayName="Annotation processor artifactId", description="The artifactId of the annotation processor.", example="hibernate-jpamodelgen", required=true)
    private final String artifactId;
    @Option(displayName="Enforce managed version", description="If the new annotation processor has a managed version, this flag can be used to explicitly set the version on the annotation processor with the version of the managed dependency. The default for this flag is `false`.", required=false)
    @Nullable
    private final Boolean enforceManagedVersion;

    public String getDisplayName() {
        return "Add an annotation processor to the Maven Compiler plugin configuration";
    }

    public String getDescription() {
        return "Add an annotation processor to the Maven Compiler plugin configuration.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag mavenCompilerPluginTag = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (this.isPluginTag("org.apache.maven.plugins", "maven-compiler-plugin")) {
                    String managedVersion;
                    Optional configuration = mavenCompilerPluginTag.getChild("configuration");
                    String annotationProcessorPath = "<groupId>" + AddMavenCompilerAnnotationProcessor.this.groupId + "</groupId>\n<artifactId>" + AddMavenCompilerAnnotationProcessor.this.artifactId + "</artifactId>";
                    if (Boolean.TRUE.equals(AddMavenCompilerAnnotationProcessor.this.enforceManagedVersion) && (managedVersion = this.getManagedVersion(AddMavenCompilerAnnotationProcessor.this.groupId, AddMavenCompilerAnnotationProcessor.this.artifactId)) != null) {
                        annotationProcessorPath = annotationProcessorPath + "<version>" + managedVersion + "</version>";
                    }
                    if (configuration.isPresent()) {
                        Optional annotationProcessorPathsWrapper = ((Xml.Tag)configuration.get()).getChild("annotationProcessorPaths");
                        if (annotationProcessorPathsWrapper.isPresent()) {
                            String childName;
                            List annotationProcessorPaths = ((Xml.Tag)annotationProcessorPathsWrapper.get()).getChildren();
                            String string = childName = annotationProcessorPaths.size() > 0 ? ((Xml.Tag)annotationProcessorPaths.get(0)).getName() : "path";
                            if (!annotationProcessorPaths.stream().anyMatch(t -> AddMavenCompilerAnnotationProcessor.this.groupId.equals(t.getChildValue("groupId").orElse(null)) && AddMavenCompilerAnnotationProcessor.this.artifactId.equals(t.getChildValue("artifactId").orElse(null)))) {
                                mavenCompilerPluginTag = AddToTagVisitor.addToTag((Xml.Tag)mavenCompilerPluginTag, (Xml.Tag)((Xml.Tag)annotationProcessorPathsWrapper.get()), (Xml.Tag)Xml.Tag.build((String)("<" + childName + ">\n" + annotationProcessorPath + "\n</" + childName + ">")), (Cursor)this.getCursor().getParentOrThrow());
                            }
                        } else {
                            mavenCompilerPluginTag = AddToTagVisitor.addToTag((Xml.Tag)mavenCompilerPluginTag, (Xml.Tag)((Xml.Tag)configuration.get()), (Xml.Tag)Xml.Tag.build((String)("<annotationProcessorPaths>\n<path>\n" + annotationProcessorPath + "\n</path>\n</annotationProcessorPaths>")), (Cursor)this.getCursor().getParentOrThrow());
                        }
                    } else {
                        mavenCompilerPluginTag = AddToTagVisitor.addToTag((Xml.Tag)mavenCompilerPluginTag, (Xml.Tag)Xml.Tag.build((String)("<configuration>\n<annotationProcessorPaths>\n<path>\n" + annotationProcessorPath + "\n</path>\n</annotationProcessorPaths>\n</configuration>")), (Cursor)this.getCursor().getParentOrThrow());
                    }
                }
                return mavenCompilerPluginTag;
            }

            private String getManagedVersion(String groupId, String artifactId) {
                MavenResolutionResult result = this.getResolutionResult();
                for (ResolvedManagedDependency managedDependency : result.getPom().getDependencyManagement()) {
                    if (!groupId.equals(managedDependency.getGroupId()) || !artifactId.equals(managedDependency.getArtifactId())) continue;
                    return managedDependency.getVersion();
                }
                return null;
            }
        };
    }

    @ConstructorProperties(value={"groupId", "artifactId", "enforceManagedVersion"})
    public AddMavenCompilerAnnotationProcessor(String groupId, String artifactId, @Nullable Boolean enforceManagedVersion) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.enforceManagedVersion = enforceManagedVersion;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public Boolean getEnforceManagedVersion() {
        return this.enforceManagedVersion;
    }

    @NonNull
    public String toString() {
        return "AddMavenCompilerAnnotationProcessor(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", enforceManagedVersion=" + this.getEnforceManagedVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddMavenCompilerAnnotationProcessor)) {
            return false;
        }
        AddMavenCompilerAnnotationProcessor other = (AddMavenCompilerAnnotationProcessor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$enforceManagedVersion = this.getEnforceManagedVersion();
        Boolean other$enforceManagedVersion = other.getEnforceManagedVersion();
        if (this$enforceManagedVersion == null ? other$enforceManagedVersion != null : !((Object)this$enforceManagedVersion).equals(other$enforceManagedVersion)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddMavenCompilerAnnotationProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $enforceManagedVersion = this.getEnforceManagedVersion();
        result = result * 59 + ($enforceManagedVersion == null ? 43 : ((Object)$enforceManagedVersion).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        return result;
    }
}

