/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.camel30;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCamelQuarkusJavaVisitor
extends JavaIsoVisitor<ExecutionContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCamelQuarkusJavaVisitor.class);
    private boolean camel = false;
    private LinkedList<JavaType> implementsList = new LinkedList();
    private static Map<String, MethodMatcher> methodMatchers = new HashMap<String, MethodMatcher>();

    public final J.Import visitImport(J.Import _import, ExecutionContext context) {
        if (_import.getTypeName().contains("org.apache.camel")) {
            this.camel = true;
        }
        if (!this.camel) {
            return _import;
        }
        return this.executeVisitWithCatch(() -> this.doVisitImport(_import, context), _import, context);
    }

    public final J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext context) {
        if (classDecl.getImplements() != null && !classDecl.getImplements().isEmpty()) {
            this.implementsList.addAll(classDecl.getImplements().stream().map(i -> i.getType()).collect(Collectors.toList()));
        }
        return this.executeVisitWithCatch(() -> this.doVisitClassDeclaration(classDecl, context), classDecl, context);
    }

    public final J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext context) {
        if (!this.camel) {
            return fieldAccess;
        }
        return this.executeVisitWithCatch(() -> this.doVisitFieldAccess(fieldAccess, context), fieldAccess, context);
    }

    public final J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext context) {
        if (!this.camel) {
            return method;
        }
        return this.executeVisitWithCatch(() -> this.doVisitMethodDeclaration(method, context), method, context);
    }

    public final J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
        if (!this.camel) {
            return method;
        }
        return this.executeVisitWithCatch(() -> this.doVisitMethodInvocation(method, context), method, context);
    }

    public final J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext context) {
        if (!this.camel) {
            return annotation;
        }
        return this.executeVisitWithCatch(() -> this.doVisitAnnotation(annotation, context), annotation, context);
    }

    protected J.Import doVisitImport(J.Import _import, ExecutionContext context) {
        return super.visitImport(_import, (Object)context);
    }

    protected J.ClassDeclaration doVisitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext context) {
        return super.visitClassDeclaration(classDecl, (Object)context);
    }

    protected J.FieldAccess doVisitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext context) {
        return super.visitFieldAccess(fieldAccess, (Object)context);
    }

    protected J.MethodDeclaration doVisitMethodDeclaration(J.MethodDeclaration method, ExecutionContext context) {
        return super.visitMethodDeclaration(method, (Object)context);
    }

    protected J.MethodInvocation doVisitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
        return super.visitMethodInvocation(method, (Object)context);
    }

    protected J.Annotation doVisitAnnotation(J.Annotation annotation, ExecutionContext context) {
        return super.visitAnnotation(annotation, (Object)context);
    }

    protected LinkedList<JavaType> getImplementsList() {
        return this.implementsList;
    }

    protected <T extends J> T executeVisitWithCatch(Supplier<T> visitMethod, T origValue, ExecutionContext context) {
        try {
            return (T)((J)visitMethod.get());
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Internal error detected in %s, recipe is skipped.", context.getMessage("org.openrewrite.currentRecipe").getClass().getSimpleName()), (Throwable)e);
            return origValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MethodMatcher getMethodMatcher(String signature) {
        Map<String, MethodMatcher> map = methodMatchers;
        synchronized (map) {
            MethodMatcher matcher = methodMatchers.get(signature);
            if (matcher == null) {
                matcher = new MethodMatcher(signature);
                methodMatchers.put(signature, matcher);
            }
            return matcher;
        }
    }
}

