/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.cli.letsencrypt;

import io.quarkus.tls.cli.letsencrypt.AcmeClient;
import io.quarkus.tls.cli.letsencrypt.LetsEncryptConstants;
import io.quarkus.tls.cli.letsencrypt.LetsEncryptHelpers;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="issue-certificate", mixinStandardHelpOptions=true, description={"Issue a certificate from let's encrypt. This command runs the HTTP 01 challenge of let's encrypt. Make sure the application is running before running this command."})
public class LetsEncryptIssueCommand
implements Callable<Integer> {
    static System.Logger LOGGER = System.getLogger("lets-encrypt-issue");
    @CommandLine.Option(names={"-d", "--domain"}, description={"The domain for which the certificate will be generated"}, required=true)
    String domain;
    @CommandLine.Option(names={"-n", "--tls-configuration-name"}, description={"The name of the TLS configuration to be used, if not set, the default configuration is used"})
    String tlsConfigurationName;
    @CommandLine.Option(names={"--management-url"}, description={"The URL of the management endpoint to use for the ACME challenge"}, required=true)
    String managementUrl;
    @CommandLine.Option(names={"--management-user"}, description={"The username to use for the management endpoint"})
    String managementUser;
    @CommandLine.Option(names={"--management-password"}, description={"The password to use for the management endpoint"})
    String managementPassword;
    @CommandLine.Option(names={"--email"}, description={"The email of the account to use for the ACME challenge"}, required=true)
    String email;
    @CommandLine.Option(names={"--staging"}, description={"Whether to use the staging environment of Let's Encrypt"}, defaultValue="false")
    boolean staging;

    @Override
    public Integer call() throws Exception {
        AcmeClient client = new AcmeClient(this.managementUrl, this.managementUser, this.managementPassword, this.tlsConfigurationName);
        if (!LetsEncryptConstants.LETS_ENCRYPT_DIR.exists()) {
            LOGGER.log(System.Logger.Level.ERROR, "The .letsencrypt directory does not exist, please run the `quarkus tls letsencrypt prepare` command first");
            return 1;
        }
        if (!LetsEncryptConstants.CERT_FILE.isFile() || !LetsEncryptConstants.KEY_FILE.isFile()) {
            LOGGER.log(System.Logger.Level.ERROR, "The certificate and key files do not exist, please run the `quarkus tls letsencrypt prepare` command first");
            return 1;
        }
        if (!LetsEncryptConstants.DOT_ENV_FILE.isFile()) {
            LOGGER.log(System.Logger.Level.ERROR, "The .env file does not exist, please run the `quarkus tls letsencrypt prepare` command first");
            return 1;
        }
        if (!client.checkReadiness()) {
            return 1;
        }
        LetsEncryptHelpers.createAccount(client, LetsEncryptConstants.LETS_ENCRYPT_DIR.getAbsolutePath(), this.staging, this.email);
        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd35 Requesting initial certificate from {0} Let's Encrypt", this.staging ? "staging" : "");
        LetsEncryptHelpers.issueCertificate(client, LetsEncryptConstants.LETS_ENCRYPT_DIR, this.staging, this.domain, LetsEncryptConstants.CERT_FILE, LetsEncryptConstants.KEY_FILE);
        LetsEncryptHelpers.adjustPermissions(LetsEncryptConstants.CERT_FILE, LetsEncryptConstants.KEY_FILE);
        client.certificateChainAndKeyAreReady();
        LOGGER.log(System.Logger.Level.INFO, "\u2705 Successfully obtained certificate for {0}", this.domain);
        return 0;
    }
}

