/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.parsson;

import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonConfig;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.parsson.JsonContext;
import org.eclipse.parsson.JsonMessages;
import org.eclipse.parsson.JsonNumberImpl;
import org.eclipse.parsson.JsonStringImpl;
import org.eclipse.parsson.JsonWriterImpl;
import org.eclipse.parsson.MapUtil;

class JsonObjectBuilderImpl
implements JsonObjectBuilder {
    protected Map<String, JsonValue> valueMap;
    private final JsonContext jsonContext;
    private final DuplicateStrategy duplicateStrategy;

    JsonObjectBuilderImpl(JsonContext jsonContext) {
        this.jsonContext = jsonContext;
        this.duplicateStrategy = DuplicateStrategy.strategyFromProperty(jsonContext.config("jakarta.json.JsonConfig.keyStrategy"), jsonContext.rejectDuplicateKeys());
    }

    JsonObjectBuilderImpl(JsonObject object, JsonContext jsonContext) {
        this(jsonContext);
        this.valueMap = new LinkedHashMap<String, JsonValue>();
        this.valueMap.putAll(object);
    }

    JsonObjectBuilderImpl(Map<String, ?> map, JsonContext jsonContext) {
        this(jsonContext);
        this.valueMap = new LinkedHashMap<String, JsonValue>();
        this.populate(map);
    }

    @Override
    public JsonObjectBuilder add(String name, JsonValue value) {
        this.validateName(name);
        this.validateValue(value);
        this.putValueMap(name, value);
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, String value) {
        this.validateName(name);
        this.validateValue(value);
        this.putValueMap(name, new JsonStringImpl(value));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, BigInteger value) {
        this.validateName(name);
        this.validateValue(value);
        this.putValueMap(name, JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, BigDecimal value) {
        this.validateName(name);
        this.validateValue(value);
        this.putValueMap(name, JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, int value) {
        this.validateName(name);
        this.putValueMap(name, JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, long value) {
        this.validateName(name);
        this.putValueMap(name, JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, double value) {
        this.validateName(name);
        this.putValueMap(name, JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, boolean value) {
        this.validateName(name);
        this.putValueMap(name, value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    @Override
    public JsonObjectBuilder addNull(String name) {
        this.validateName(name);
        this.putValueMap(name, JsonValue.NULL);
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, JsonObjectBuilder builder) {
        this.validateName(name);
        if (builder == null) {
            throw new NullPointerException(JsonMessages.OBJBUILDER_OBJECT_BUILDER_NULL());
        }
        this.putValueMap(name, builder.build());
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, JsonArrayBuilder builder) {
        this.validateName(name);
        if (builder == null) {
            throw new NullPointerException(JsonMessages.OBJBUILDER_ARRAY_BUILDER_NULL());
        }
        this.putValueMap(name, builder.build());
        return this;
    }

    @Override
    public JsonObjectBuilder addAll(JsonObjectBuilder builder) {
        if (builder == null) {
            throw new NullPointerException(JsonMessages.OBJBUILDER_OBJECT_BUILDER_NULL());
        }
        if (this.valueMap == null) {
            this.valueMap = new LinkedHashMap<String, JsonValue>();
        }
        this.valueMap.putAll(builder.build());
        return this;
    }

    @Override
    public JsonObjectBuilder remove(String name) {
        this.validateName(name);
        this.valueMap.remove(name);
        return this;
    }

    @Override
    public JsonObject build() {
        Map<String, JsonValue> snapshot = this.valueMap == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.valueMap);
        this.valueMap = null;
        return new JsonObjectImpl(snapshot, this.jsonContext);
    }

    private void populate(Map<String, ?> map) {
        Set<String> fields = map.keySet();
        for (String field : fields) {
            Object value = map.get(field);
            if (value instanceof Optional) {
                ((Optional)value).ifPresent(v -> this.valueMap.put(field, MapUtil.handle(v, this.jsonContext)));
                continue;
            }
            this.valueMap.put(field, MapUtil.handle(value, this.jsonContext));
        }
    }

    private void putValueMap(String name, JsonValue value) {
        if (this.valueMap == null) {
            this.valueMap = new LinkedHashMap<String, JsonValue>();
        }
        JsonValue previousValue = this.valueMap.get(name);
        this.valueMap.put(name, this.duplicateStrategy.getValue(name, value, previousValue));
    }

    private void validateName(String name) {
        if (name == null) {
            throw new NullPointerException(JsonMessages.OBJBUILDER_NAME_NULL());
        }
    }

    private void validateValue(Object value) {
        if (value == null) {
            throw new NullPointerException(JsonMessages.OBJBUILDER_VALUE_NULL());
        }
    }

    private static enum DuplicateStrategy {
        NONE(JsonConfig.KeyStrategy.NONE){

            @Override
            protected JsonValue getValue(String name, JsonValue value, JsonValue previous) {
                if (previous != null) {
                    throw new IllegalStateException(JsonMessages.DUPLICATE_KEY(name));
                }
                return value;
            }
        }
        ,
        FIRST(JsonConfig.KeyStrategy.FIRST){

            @Override
            protected JsonValue getValue(String name, JsonValue value, JsonValue previous) {
                if (previous != null) {
                    return previous;
                }
                return value;
            }
        }
        ,
        LAST(JsonConfig.KeyStrategy.LAST){

            @Override
            protected JsonValue getValue(String name, JsonValue value, JsonValue previous) {
                return value;
            }
        };

        private final JsonConfig.KeyStrategy property;

        private DuplicateStrategy(JsonConfig.KeyStrategy property) {
            this.property = property;
        }

        private static DuplicateStrategy strategyFromProperty(Object value, boolean rejectDuplicateKeys) {
            if (value != null) {
                for (DuplicateStrategy strategy : DuplicateStrategy.values()) {
                    if (!strategy.property.equals(value)) continue;
                    return strategy;
                }
            }
            if (rejectDuplicateKeys) {
                return NONE;
            }
            return LAST;
        }

        protected abstract JsonValue getValue(String var1, JsonValue var2, JsonValue var3);
    }

    private static final class JsonObjectImpl
    extends AbstractMap<String, JsonValue>
    implements JsonObject {
        private final Map<String, JsonValue> valueMap;
        private final JsonContext jsonContext;
        private int hashCode;

        JsonObjectImpl(Map<String, JsonValue> valueMap, JsonContext jsonContext) {
            this.valueMap = valueMap;
            this.jsonContext = jsonContext;
        }

        @Override
        public JsonArray getJsonArray(String name) {
            return (JsonArray)this.get(name);
        }

        @Override
        public JsonObject getJsonObject(String name) {
            return (JsonObject)this.get(name);
        }

        @Override
        public JsonNumber getJsonNumber(String name) {
            return (JsonNumber)this.get(name);
        }

        @Override
        public JsonString getJsonString(String name) {
            return (JsonString)this.get(name);
        }

        @Override
        public String getString(String name) {
            return this.getJsonString(name).getString();
        }

        @Override
        public String getString(String name, String defaultValue) {
            JsonValue value = this.get(name);
            if (value instanceof JsonString) {
                return ((JsonString)value).getString();
            }
            return defaultValue;
        }

        @Override
        public int getInt(String name) {
            return this.getJsonNumber(name).intValue();
        }

        @Override
        public int getInt(String name, int defaultValue) {
            JsonValue value = this.get(name);
            if (value instanceof JsonNumber) {
                return ((JsonNumber)value).intValue();
            }
            return defaultValue;
        }

        @Override
        public boolean getBoolean(String name) {
            JsonValue value = this.get(name);
            if (value == null) {
                throw new NullPointerException();
            }
            if (value == JsonValue.TRUE) {
                return true;
            }
            if (value == JsonValue.FALSE) {
                return false;
            }
            throw new ClassCastException();
        }

        @Override
        public boolean getBoolean(String name, boolean defaultValue) {
            JsonValue value = this.get(name);
            if (value == JsonValue.TRUE) {
                return true;
            }
            if (value == JsonValue.FALSE) {
                return false;
            }
            return defaultValue;
        }

        @Override
        public boolean isNull(String name) {
            return this.get(name).equals(JsonValue.NULL);
        }

        @Override
        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.OBJECT;
        }

        @Override
        public Set<Map.Entry<String, JsonValue>> entrySet() {
            return this.valueMap.entrySet();
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = super.hashCode();
            }
            return this.hashCode;
        }

        @Override
        public String toString() {
            StringWriter sw = new StringWriter();
            try (JsonWriterImpl jw = new JsonWriterImpl(sw, this.jsonContext);){
                jw.write(this);
            }
            return sw.toString();
        }

        @Override
        public JsonObject asJsonObject() {
            return this;
        }

        @Override
        public int size() {
            return this.valueMap.size();
        }

        @Override
        public JsonValue get(Object key) {
            return this.valueMap.get(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.valueMap.containsKey(key);
        }
    }
}

