/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.certs.ca;

import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import io.smallrye.certs.ca.CaGenerator;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Base64;

public class MacCAInstaller {
    static System.Logger LOGGER = System.getLogger(CaGenerator.class.getName());

    public static void installCAOnMac(String cn, File ca) throws Exception {
        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd25 Installing CA certificate (issuer: {0}) into your operating system keychain. Your admin password may be asked.", cn);
        ProcessBuilder pb = new ProcessBuilder("sudo", "security", "-v", "add-trusted-cert", "-d", "-r", "trustRoot", "-k", "/Library/Keychains/System.keychain", ca.getAbsolutePath());
        pb.inheritIO();
        pb.start().waitFor();
        LOGGER.log(System.Logger.Level.DEBUG, "\t Certificate added to the keychain");
        File tmp = new File("trust-settings.plist");
        pb = new ProcessBuilder("sudo", "security", "trust-settings-export", "-d", tmp.getAbsolutePath());
        pb.inheritIO();
        pb.start().waitFor();
        LOGGER.log(System.Logger.Level.DEBUG, "\t Trust settings exported to {0}", tmp.getAbsolutePath());
        pb = new ProcessBuilder("sudo", "chown", System.getProperty("user.name"), tmp.getAbsolutePath());
        pb.inheritIO();
        pb.start().waitFor();
        MacCAInstaller.updateCertificateTrustSettings(cn, tmp);
        LOGGER.log(System.Logger.Level.DEBUG, "\t Trust settings updated");
        pb = new ProcessBuilder("sudo", "security", "trust-settings-import", "-d", tmp.getAbsolutePath());
        pb.inheritIO();
        pb.start().waitFor();
        LOGGER.log(System.Logger.Level.DEBUG, "\t Trust settings imported");
    }

    private static void updateCertificateTrustSettings(String cn, File plist) throws Exception {
        String content = Files.readString(plist.toPath());
        NSDictionary main = (NSDictionary)PropertyListParser.parse(content.getBytes());
        NSDictionary certs = (NSDictionary)main.get("trustList");
        boolean found = false;
        for (int i = 0; i < certs.allKeys().length; ++i) {
            String k = certs.allKeys()[i];
            NSDictionary value = (NSDictionary)certs.objectForKey(k);
            NSData data = (NSData)value.get("issuerName");
            String v = data.getBase64EncodedData();
            byte[] decodedBytes = Base64.getDecoder().decode(v.getBytes());
            String in = new String(decodedBytes);
            if (!in.contains(cn)) continue;
            LOGGER.log(System.Logger.Level.DEBUG, "found ca certificate in plist");
            found = true;
            NSArray settings = new NSArray(2);
            NSDictionary dict0 = new NSDictionary();
            NSDictionary dict1 = new NSDictionary();
            dict0.put("kSecTrustSettingsPolicy", new NSData("KoZIhvdjZAED"));
            dict0.put("kSecTrustSettingsPolicyName", new NSString("sslServer"));
            dict0.put("kSecTrustSettingsResult", new NSNumber(2));
            dict1.put("kSecTrustSettingsPolicy", new NSData("KoZIhvdjZAEC"));
            dict1.put("kSecTrustSettingsPolicyName", new NSString("basicX509"));
            dict1.put("kSecTrustSettingsResult", new NSNumber(2));
            settings.setValue(0, dict0);
            settings.setValue(1, dict1);
            value.put("trustSettings", settings);
        }
        if (!found) {
            LOGGER.log(System.Logger.Level.INFO, "\ud83d\udeab CA certificate not found in plist");
        }
        Files.writeString(plist.toPath(), (CharSequence)main.toXMLPropertyList(), new OpenOption[0]);
    }
}

