/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.cli.letsencrypt;

import io.smallrye.common.constraint.Assert;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.wildfly.security.x500.cert.acme.AcmeAccount;
import org.wildfly.security.x500.cert.acme.AcmeChallenge;
import org.wildfly.security.x500.cert.acme.AcmeClientSpi;
import org.wildfly.security.x500.cert.acme.AcmeException;

public class AcmeClient
extends AcmeClientSpi {
    static System.Logger LOGGER = System.getLogger("lets-encrypt-acme-client");
    private static final String TOKEN_REGEX = "[A-Za-z0-9_-]+";
    private final String challengeUrl;
    private final String certsUrl;
    private final WebClientOptions options;
    private final Vertx vertx = Vertx.vertx();
    final String managementUser;
    final String managementPassword;
    final String managementKey;
    private final WebClient managementClient;

    public AcmeClient(String managementUrl, String managementUser, String managementPassword, String managementKey) {
        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd35 Creating AcmeClient with {0}", managementUrl);
        this.options = new WebClientOptions();
        if (managementUrl.startsWith("https://")) {
            this.options.setSsl(true).setTrustAll(true).setVerifyHost(false);
        }
        this.managementClient = WebClient.create(this.vertx, this.options);
        if (managementUrl.endsWith("/q/lets-encrypt")) {
            this.challengeUrl = managementUrl + "/challenge";
            this.certsUrl = managementUrl + "/certs";
        } else {
            this.challengeUrl = managementUrl + "/q/lets-encrypt/challenge";
            this.certsUrl = managementUrl + "/q/lets-encrypt/certs";
        }
        this.managementUser = managementUser;
        this.managementPassword = managementPassword;
        this.managementKey = managementKey;
    }

    public boolean checkReadiness() {
        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd35 Checking management challenge endpoint status using {0}", this.challengeUrl);
        HttpRequest<Buffer> request = this.managementClient.getAbs(this.challengeUrl);
        this.addKeyAndUser(request);
        try {
            HttpResponse<Buffer> response = this.await(request.send());
            int status = response.statusCode();
            switch (status) {
                case 200: 
                case 204: {
                    return true;
                }
                case 404: {
                    LOGGER.log(System.Logger.Level.ERROR, "\u26a0\ufe0f Let's Encrypt challenge endpoint is not found, make sure that the build-time property `quarkus.tls.lets-encrypt.enabled` is set to `true`");
                    return false;
                }
            }
            LOGGER.log(System.Logger.Level.WARNING, "\u26a0\ufe0f Unexpected status code from the management challenge endpoint: " + status);
            return false;
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.DEBUG, "Failed to check the management challenge endpoint status", (Throwable)e);
            LOGGER.log(System.Logger.Level.ERROR, "\u26a0\ufe0f Quarkus management endpoint is not ready, make sure the Quarkus application is running.");
            return false;
        }
    }

    @Override
    public AcmeChallenge proveIdentifierControl(AcmeAccount account, List<AcmeChallenge> challenges) throws AcmeException {
        Assert.checkNotNullParam("account", account);
        Assert.checkNotNullParam("challenges", challenges);
        AcmeChallenge selectedChallenge = null;
        for (AcmeChallenge challenge : challenges) {
            if (challenge.getType() != AcmeChallenge.Type.HTTP_01) continue;
            LOGGER.log(System.Logger.Level.DEBUG, "HTTP 01 challenge is selected");
            selectedChallenge = challenge;
            break;
        }
        if (selectedChallenge == null) {
            throw new RuntimeException("Missing certificate authority challenge");
        }
        String token = selectedChallenge.getToken();
        if (!token.matches(TOKEN_REGEX)) {
            throw new RuntimeException("Invalid certificate authority challenge");
        }
        LOGGER.log(System.Logger.Level.DEBUG, "Preparing a selected challenge content for token {0}", token);
        String selectedChallengeString = selectedChallenge.getKeyAuthorization(account);
        if (this.managementClient != null) {
            HttpRequest<Buffer> request = this.managementClient.getAbs(this.challengeUrl);
            request.addQueryParam("challenge-resource", token).addQueryParam("challenge-content", selectedChallengeString);
            this.addKeyAndUser(request);
            LOGGER.log(System.Logger.Level.DEBUG, "Sending token {0} and challenge content to the management challenge endpoint", token, selectedChallengeString);
            HttpResponse<Buffer> response = this.await(request.send());
            if (response.statusCode() != 204) {
                LOGGER.log(System.Logger.Level.ERROR, "\u26a0\ufe0f Failed to upload challenge content to the management challenge endpoint, status code: " + response.statusCode());
                throw new RuntimeException("Failed to respond to certificate authority challenge");
            }
            LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd35 Challenge ready for token {0}, waiting for Let's Encrypt to validate...", token);
        }
        return selectedChallenge;
    }

    @Override
    public void cleanupAfterChallenge(AcmeAccount account, AcmeChallenge challenge) throws AcmeException {
        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd35 Performing cleanup after the challenge");
        Assert.checkNotNullParam("account", account);
        Assert.checkNotNullParam("challenge", challenge);
        String token = challenge.getToken();
        if (!token.matches(TOKEN_REGEX)) {
            throw new RuntimeException("Invalid certificate authority challenge");
        }
        LOGGER.log(System.Logger.Level.DEBUG, "Requesting the management challenge endpoint to delete a challenge resource {0}", token);
        HttpRequest<Buffer> request = this.managementClient.deleteAbs(this.challengeUrl);
        this.addKeyAndUser(request);
        HttpResponse<Buffer> response = this.await(request.send());
        if (response.statusCode() != 204) {
            throw new RuntimeException("Failed to clear challenge content in the Quarkus management endpoint");
        }
    }

    public void certificateChainAndKeyAreReady() {
        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd35 Notifying management challenge endpoint that a new certificate chain and private key are ready");
        HttpRequest<Buffer> request = this.managementClient.postAbs(this.certsUrl);
        this.addKeyAndUser(request);
        HttpResponse<Buffer> response = this.await(request.send());
        if (response.statusCode() != 204) {
            throw new RuntimeException("Failed to notify the Quarkus management endpoint");
        }
    }

    private void addKeyAndUser(HttpRequest<Buffer> request) {
        if (this.managementKey != null) {
            request.addQueryParam("key", this.managementKey);
        }
        if (this.managementUser != null && this.managementPassword != null) {
            request.basicAuthentication(this.managementUser, this.managementPassword);
        }
    }

    private <T> T await(Future<T> future) {
        try {
            return future.toCompletionStage().toCompletableFuture().get(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

