/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.certs.chain;

import io.smallrye.certs.CertificateUtils;
import java.io.File;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class CertificateChainGenerator {
    private String cn = "localhost";
    private List<String> sans = List.of("DNS:localhost");
    private final File baseDir;

    public CertificateChainGenerator(File baseDir) {
        this.baseDir = baseDir;
        if (!baseDir.isDirectory()) {
            baseDir.mkdirs();
        }
    }

    public CertificateChainGenerator withCN(String cn) {
        this.cn = cn;
        return this;
    }

    public CertificateChainGenerator withSAN(List<String> san) {
        this.sans = san;
        return this;
    }

    public void generate() throws Exception {
        KeyPair rootKeyPair = this.generateKeyPair();
        X509Certificate rootCertificate = this.generateRootCertificate(rootKeyPair);
        KeyPair intermediaryKeyPair = this.generateKeyPair();
        X509Certificate intermediaryCertificate = this.generateIntermediaryCertificate(intermediaryKeyPair, rootKeyPair, rootCertificate);
        KeyPair leafKeyPair = this.generateKeyPair();
        X509Certificate leafCertificate = this.generateLeafCertificate(leafKeyPair, intermediaryKeyPair, intermediaryCertificate);
        CertificateUtils.writeCertificateToPEM(rootCertificate, new File(this.baseDir, "root.crt"), new X509Certificate[0]);
        CertificateUtils.writePrivateKeyToPem(rootKeyPair.getPrivate(), new File(this.baseDir, "root.key"));
        CertificateUtils.writeCertificateToPEM(intermediaryCertificate, new File(this.baseDir, "intermediate.crt"), new X509Certificate[0]);
        CertificateUtils.writePrivateKeyToPem(intermediaryKeyPair.getPrivate(), new File(this.baseDir, "intermediate.key"));
        CertificateUtils.writeCertificateToPEM(leafCertificate, new File(this.baseDir, this.cn + ".crt"), intermediaryCertificate);
        CertificateUtils.writePrivateKeyToPem(leafKeyPair.getPrivate(), new File(this.baseDir, this.cn + ".key"));
    }

    private KeyPair generateKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(2048, new SecureRandom());
        return keyPairGenerator.generateKeyPair();
    }

    private X509Certificate generateRootCertificate(KeyPair rootKeyPair) throws CertIOException, NoSuchAlgorithmException, OperatorCreationException, CertificateException {
        SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance(ASN1Sequence.getInstance(rootKeyPair.getPublic().getEncoded()));
        X500Name issuer = new X500Name("CN=quarkus-root,O=Quarkus Development");
        X500Name subject = new X500Name("CN=root");
        Date yesterday = new Date(System.currentTimeMillis() - 86400000L);
        Date oneYear = new Date(System.currentTimeMillis() + 31536000000L);
        X509v3CertificateBuilder certGen = new X509v3CertificateBuilder(issuer, BigInteger.valueOf(System.currentTimeMillis()), yesterday, oneYear, subject, keyInfo);
        certGen.addExtension(Extension.keyUsage, true, new KeyUsage(4));
        certGen.addExtension(Extension.basicConstraints, true, new BasicConstraints(true));
        certGen.addExtension(Extension.subjectKeyIdentifier, false, new JcaX509ExtensionUtils().createSubjectKeyIdentifier(rootKeyPair.getPublic()));
        JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder("SHA256WithRSAEncryption");
        ContentSigner signer = contentSignerBuilder.build(rootKeyPair.getPrivate());
        X509CertificateHolder holder = certGen.build(signer);
        return new JcaX509CertificateConverter().getCertificate(holder);
    }

    private X509Certificate generateIntermediaryCertificate(KeyPair intermediaryKeyPair, KeyPair rootKeyPair, X509Certificate rootCertificate) throws NoSuchAlgorithmException, CertIOException, OperatorCreationException, CertificateException {
        SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance(ASN1Sequence.getInstance(intermediaryKeyPair.getPublic().getEncoded()));
        Date yesterday = new Date(System.currentTimeMillis() - 86400000L);
        Date oneYear = new Date(System.currentTimeMillis() + 31536000000L);
        X509v3CertificateBuilder certGen = new X509v3CertificateBuilder(new X500Name(rootCertificate.getSubjectX500Principal().getName()), BigInteger.valueOf(System.currentTimeMillis()), yesterday, oneYear, new X500Name("CN=intermediary"), keyInfo);
        certGen.addExtension(Extension.keyUsage, true, new KeyUsage(132));
        certGen.addExtension(Extension.basicConstraints, true, new BasicConstraints(true));
        certGen.addExtension(Extension.subjectKeyIdentifier, false, new JcaX509ExtensionUtils().createSubjectKeyIdentifier(intermediaryKeyPair.getPublic()));
        JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder("SHA256WithRSAEncryption");
        ContentSigner contentSigner = contentSignerBuilder.build(rootKeyPair.getPrivate());
        return new JcaX509CertificateConverter().getCertificate(certGen.build(contentSigner));
    }

    private X509Certificate generateLeafCertificate(KeyPair leafKeyPair, KeyPair intermediaryKeyPair, X509Certificate intermediaryCertificate) throws NoSuchAlgorithmException, CertIOException, OperatorCreationException, CertificateException {
        SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance(ASN1Sequence.getInstance(leafKeyPair.getPublic().getEncoded()));
        Instant before = Instant.now().minus(2L, ChronoUnit.DAYS);
        Instant after = Instant.now().plus(2L, ChronoUnit.DAYS);
        X509v3CertificateBuilder certGen = new X509v3CertificateBuilder(new X500Name(intermediaryCertificate.getSubjectX500Principal().getName()), BigInteger.valueOf(System.currentTimeMillis()), new Date(before.toEpochMilli()), new Date(after.toEpochMilli()), new X500Name("CN=" + this.cn), keyInfo);
        certGen.addExtension(Extension.keyUsage, true, new KeyUsage(248));
        certGen.addExtension(Extension.subjectKeyIdentifier, false, new JcaX509ExtensionUtils().createSubjectKeyIdentifier(leafKeyPair.getPublic()));
        DERSequence subjectAlternativeNames = new DERSequence((ASN1Encodable[])this.sans.stream().map(s -> {
            if (s.startsWith("DNS:")) {
                return new GeneralName(2, s.substring(4));
            }
            if (s.startsWith("IP:")) {
                return new GeneralName(7, s.substring(3));
            }
            return new GeneralName(2, (String)s);
        }).toArray(ASN1Encodable[]::new));
        certGen.addExtension(Extension.subjectAlternativeName, false, subjectAlternativeNames);
        JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder("SHA256WithRSAEncryption");
        ContentSigner contentSigner = contentSignerBuilder.build(intermediaryKeyPair.getPrivate());
        return new JcaX509CertificateConverter().getCertificate(certGen.build(contentSigner));
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

