/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.ldap;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldif.LDIFReader;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;

public class LdapServerTestResource
implements QuarkusTestResourceLifecycleManager {
    protected InMemoryDirectoryServer ldapServer;

    public LdapServerTestResource() throws LDAPException {
        InMemoryListenerConfig listenerConfig = new InMemoryListenerConfig("listener", InetAddress.getLoopbackAddress(), 0, null, null, null);
        InMemoryDirectoryServerConfig inMemoryDirectoryServerConfig = new InMemoryDirectoryServerConfig(new String[]{"dc=quarkus,dc=io"});
        inMemoryDirectoryServerConfig.setListenerConfigs(new InMemoryListenerConfig[]{listenerConfig});
        inMemoryDirectoryServerConfig.addAdditionalBindCredentials("uid=admin,ou=system", "secret");
        this.ldapServer = new InMemoryDirectoryServer(inMemoryDirectoryServerConfig);
        this.ldapServer.importFromLDIF(true, new LDIFReader(ClassLoader.getSystemResourceAsStream("quarkus-io.ldif")));
    }

    public Map<String, String> start() {
        try {
            this.ldapServer.startListening();
            System.out.println("[INFO] LDAP server started on " + InetAddress.getLoopbackAddress().getHostAddress() + ":" + this.ldapServer.getListenPort());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Collections.singletonMap("quarkus.security.ldap.dir-context.url", "ldap://" + InetAddress.getLoopbackAddress().getHostAddress() + ":" + this.ldapServer.getListenPort());
    }

    public synchronized void stop() {
        if (this.ldapServer != null) {
            this.ldapServer.shutDown(false);
            System.out.println("[INFO] LDAP server was shut down");
            this.ldapServer = null;
        }
    }

    public void inject(QuarkusTestResourceLifecycleManager.TestInjector testInjector) {
        testInjector.injectIntoFields((Object)this.ldapServer, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.MatchesType(InMemoryDirectoryServer.class));
    }
}

