/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.keycloak.server;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.quarkus.test.keycloak.server.KeycloakContainer;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.util.JsonSerialization;

public class KeycloakTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    private static KeycloakContainer keycloak;
    private static final String KEYCLOAK_REALM;
    private static final String KEYCLOAK_SERVICE_CLIENT;
    private static final String KEYCLOAK_WEB_APP_CLIENT;
    private static final Boolean KEYCLOAK_USE_HTTPS;
    private static final String TOKEN_USER_ROLES;
    private static final String TOKEN_ADMIN_ROLES;

    public Map<String, String> start() {
        keycloak = new KeycloakContainer().withUseHttps(KEYCLOAK_USE_HTTPS);
        keycloak.start();
        RealmRepresentation realm = KeycloakTestResourceLifecycleManager.createRealm(KEYCLOAK_REALM);
        KeycloakTestResourceLifecycleManager.postRealm(realm);
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("keycloak.url", keycloak.getServerUrl());
        conf.put("quarkus.oidc.auth-server-url", keycloak.getServerUrl() + "/realms/" + KEYCLOAK_REALM);
        return conf;
    }

    private static void postRealm(RealmRepresentation realm) {
        try {
            ((ValidatableResponse)((Response)KeycloakTestResourceLifecycleManager.createRequestSpec().auth().oauth2(KeycloakTestResourceLifecycleManager.getAdminAccessToken()).contentType("application/json").body(JsonSerialization.writeValueAsBytes((Object)realm)).when().post(keycloak.getServerUrl() + "/admin/realms", new Object[0])).then()).statusCode(201);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static RealmRepresentation createRealm(String name) {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm(name);
        realm.setEnabled(Boolean.valueOf(true));
        realm.setUsers(new ArrayList());
        realm.setClients(new ArrayList());
        realm.setAccessTokenLifespan(Integer.valueOf(3));
        realm.setSsoSessionMaxLifespan(Integer.valueOf(3));
        RolesRepresentation roles = new RolesRepresentation();
        ArrayList realmRoles = new ArrayList();
        roles.setRealm(realmRoles);
        realm.setRoles(roles);
        realm.getRoles().getRealm().add(new RoleRepresentation("user", null, false));
        realm.getRoles().getRealm().add(new RoleRepresentation("admin", null, false));
        realm.getRoles().getRealm().add(new RoleRepresentation("confidential", null, false));
        realm.getClients().add(KeycloakTestResourceLifecycleManager.createServiceClient(KEYCLOAK_SERVICE_CLIENT));
        realm.getClients().add(KeycloakTestResourceLifecycleManager.createWebAppClient(KEYCLOAK_WEB_APP_CLIENT));
        realm.getUsers().add(KeycloakTestResourceLifecycleManager.createUser("alice", KeycloakTestResourceLifecycleManager.getUserRoles()));
        realm.getUsers().add(KeycloakTestResourceLifecycleManager.createUser("admin", KeycloakTestResourceLifecycleManager.getAdminRoles()));
        realm.getUsers().add(KeycloakTestResourceLifecycleManager.createUser("jdoe", Arrays.asList("user", "confidential")));
        return realm;
    }

    private static String getAdminAccessToken() {
        return ((AccessTokenResponse)((Response)KeycloakTestResourceLifecycleManager.createRequestSpec().param("grant_type", new Object[]{"password"}).param("username", new Object[]{"admin"}).param("password", new Object[]{"admin"}).param("client_id", new Object[]{"admin-cli"}).when().post(keycloak.getServerUrl() + "/realms/master/protocol/openid-connect/token", new Object[0])).as(AccessTokenResponse.class)).getToken();
    }

    private static ClientRepresentation createServiceClient(String clientId) {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(clientId);
        client.setPublicClient(Boolean.valueOf(false));
        client.setSecret("secret");
        client.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        client.setServiceAccountsEnabled(Boolean.valueOf(true));
        client.setEnabled(Boolean.valueOf(true));
        client.setDefaultClientScopes(List.of("microprofile-jwt", "basic"));
        return client;
    }

    private static ClientRepresentation createWebAppClient(String clientId) {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(clientId);
        client.setPublicClient(Boolean.valueOf(false));
        client.setSecret("secret");
        client.setRedirectUris(Arrays.asList("*"));
        client.setEnabled(Boolean.valueOf(true));
        client.setDefaultClientScopes(List.of("microprofile-jwt", "basic"));
        return client;
    }

    private static UserRepresentation createUser(String username, List<String> realmRoles) {
        UserRepresentation user = new UserRepresentation();
        user.setUsername(username);
        user.setEnabled(Boolean.valueOf(true));
        user.setCredentials(new ArrayList());
        user.setRealmRoles(realmRoles);
        user.setEmail(username + "@gmail.com");
        user.setEmailVerified(Boolean.valueOf(true));
        user.setFirstName(username);
        user.setLastName(username);
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue(username);
        credential.setTemporary(Boolean.valueOf(false));
        user.getCredentials().add(credential);
        return user;
    }

    public static String getAccessToken(String userName) {
        return ((AccessTokenResponse)((Response)KeycloakTestResourceLifecycleManager.createRequestSpec().param("grant_type", new Object[]{"password"}).param("username", new Object[]{userName}).param("password", new Object[]{userName}).param("client_id", new Object[]{KEYCLOAK_SERVICE_CLIENT}).param("client_secret", new Object[]{"secret"}).param("scope", new Object[]{"openid"}).when().post(keycloak.getServerUrl() + "/realms/" + KEYCLOAK_REALM + "/protocol/openid-connect/token", new Object[0])).as(AccessTokenResponse.class)).getToken();
    }

    public static String getRefreshToken(String userName) {
        return ((AccessTokenResponse)((Response)KeycloakTestResourceLifecycleManager.createRequestSpec().param("grant_type", new Object[]{"password"}).param("username", new Object[]{userName}).param("password", new Object[]{userName}).param("client_id", new Object[]{KEYCLOAK_SERVICE_CLIENT}).param("client_secret", new Object[]{"secret"}).when().post(keycloak.getServerUrl() + "/realms/" + KEYCLOAK_REALM + "/protocol/openid-connect/token", new Object[0])).as(AccessTokenResponse.class)).getRefreshToken();
    }

    public void stop() {
        ((ValidatableResponse)((Response)KeycloakTestResourceLifecycleManager.createRequestSpec().auth().oauth2(KeycloakTestResourceLifecycleManager.getAdminAccessToken()).when().delete(keycloak.getServerUrl() + "/admin/realms/" + KEYCLOAK_REALM, new Object[0])).then()).statusCode(204);
        keycloak.stop();
    }

    private static List<String> getAdminRoles() {
        return Arrays.asList(TOKEN_ADMIN_ROLES.split(","));
    }

    private static List<String> getUserRoles() {
        return Arrays.asList(TOKEN_USER_ROLES.split(","));
    }

    private static RequestSpecification createRequestSpec() {
        return RestAssured.given();
    }

    static {
        KEYCLOAK_REALM = System.getProperty("keycloak.realm", "quarkus");
        KEYCLOAK_SERVICE_CLIENT = System.getProperty("keycloak.service.client", "quarkus-service-app");
        KEYCLOAK_WEB_APP_CLIENT = System.getProperty("keycloak.web-app.client", "quarkus-web-app");
        KEYCLOAK_USE_HTTPS = Boolean.valueOf(System.getProperty("keycloak.use.https", "true"));
        TOKEN_USER_ROLES = System.getProperty("keycloak.token.user-roles", "user");
        TOKEN_ADMIN_ROLES = System.getProperty("keycloak.token.admin-roles", "user,admin");
    }
}

