/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.test.utils;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.grpc.client.GrpcClient;
import io.vertx.grpc.client.GrpcClientChannel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRPCTestUtils {
    private static final Logger log = LoggerFactory.getLogger(GRPCTestUtils.class);

    public static Channel channel(Vertx vertx) {
        int port = vertx != null ? 8081 : 9001;
        return GRPCTestUtils.channel(vertx, port);
    }

    public static Channel channel(Vertx vertx, int port) {
        Object channel;
        if (vertx != null) {
            GrpcClient client = GrpcClient.client((Vertx)vertx);
            GrpcClientChannel gcc = new GrpcClientChannel(client, SocketAddress.inetSocketAddress((int)port, (String)"localhost"));
            channel = new InternalChannel((Channel)gcc, client);
        } else {
            channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)port).usePlaintext().build();
        }
        log.info("Channel: {}, port: {}", channel, (Object)port);
        return channel;
    }

    public static void close(Channel channel) {
        if (channel instanceof ManagedChannel) {
            ManagedChannel mc = (ManagedChannel)channel;
            mc.shutdownNow();
        } else if (channel instanceof InternalChannel) {
            InternalChannel ic = (InternalChannel)channel;
            ic.close();
        }
    }

    public static void close(Vertx vertx) {
        vertx.close().toCompletionStage().toCompletableFuture().join();
    }

    public static void close(GrpcClient client) {
        client.close().toCompletionStage().toCompletableFuture().join();
    }

    public static InputStream stream(String resource) {
        return GRPCTestUtils.class.getClassLoader().getResourceAsStream(resource);
    }

    public static Map.Entry<GrpcClient, Channel> tls(Vertx vertx, String caPem, String clientPem, String clientKey) throws IOException {
        Buffer ck;
        Buffer cb;
        Buffer buffer;
        HttpClientOptions options = new HttpClientOptions();
        options.setUseAlpn(true);
        options.setSsl(true);
        try (InputStream stream = GRPCTestUtils.stream(caPem);){
            buffer = Buffer.buffer((byte[])stream.readAllBytes());
        }
        try (InputStream stream = GRPCTestUtils.stream(clientPem);){
            cb = Buffer.buffer((byte[])stream.readAllBytes());
        }
        try (InputStream stream = GRPCTestUtils.stream(clientKey);){
            ck = Buffer.buffer((byte[])stream.readAllBytes());
        }
        options.setTrustOptions((TrustOptions)new PemTrustOptions().addCertValue(buffer));
        options.setKeyCertOptions((KeyCertOptions)new PemKeyCertOptions().setCertValue(cb).setKeyValue(ck));
        GrpcClient client = GrpcClient.client((Vertx)vertx, (HttpClientOptions)options);
        GrpcClientChannel channel = new GrpcClientChannel(client, SocketAddress.inetSocketAddress((int)8444, (String)"localhost"));
        return Map.entry(client, channel);
    }

    private static class InternalChannel
    extends Channel {
        private final Channel delegate;
        private final GrpcClient client;

        InternalChannel(Channel delegate, GrpcClient client) {
            this.delegate = delegate;
            this.client = client;
        }

        public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
            return this.delegate.newCall(methodDescriptor, callOptions);
        }

        public String authority() {
            return this.delegate.authority();
        }

        void close() {
            GRPCTestUtils.close(this.client);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

