/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.LauncherUtil;
import io.quarkus.test.common.ListeningAddress;
import io.quarkus.test.common.NativeImageStartedNotifier;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;

public class NativeImageLauncher
implements ArtifactLauncher {
    private static final int DEFAULT_PORT = 8081;
    private static final int DEFAULT_HTTPS_PORT = 8444;
    private static final long DEFAULT_IMAGE_WAIT_TIME = 60L;
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
    private final Class<?> testClass;
    private final String profile;
    private Process quarkusProcess;
    private final int httpPort;
    private final int httpsPort;
    private final long waitTimeSeconds;
    private final Map<String, String> systemProps = new HashMap<String, String>();
    private Supplier<Boolean> startedSupplier = null;
    private boolean isSsl;

    private NativeImageLauncher(Class<?> testClass, Config config) {
        this(testClass, ((OptionalInt)config.getValue("quarkus.http.test-port", OptionalInt.class)).orElse(8081), ((OptionalInt)config.getValue("quarkus.http.test-ssl-port", OptionalInt.class)).orElse(8444), ((OptionalLong)config.getValue("quarkus.test.native-image-wait-time", OptionalLong.class)).orElse(60L), config.getOptionalValue("quarkus.test.native-image-profile", String.class).orElse(null));
    }

    public NativeImageLauncher(Class<?> testClass) {
        this(testClass, LauncherUtil.installAndGetSomeConfig());
    }

    public NativeImageLauncher(Class<?> testClass, int httpPort, int httpsPort, long waitTimeSeconds, String profile) {
        this.testClass = testClass;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.waitTimeSeconds = waitTimeSeconds;
        ArrayList<NativeImageStartedNotifier> startedNotifiers = new ArrayList<NativeImageStartedNotifier>();
        for (NativeImageStartedNotifier i : ServiceLoader.load(NativeImageStartedNotifier.class)) {
            startedNotifiers.add(i);
        }
        this.profile = profile;
        if (!startedNotifiers.isEmpty()) {
            this.startedSupplier = () -> {
                for (NativeImageStartedNotifier i : startedNotifiers) {
                    if (!i.isNativeImageStarted()) continue;
                    return true;
                }
                return false;
            };
        }
    }

    @Override
    public void start() throws IOException {
        System.setProperty("test.url", TestHTTPResourceManager.getUri());
        String path = System.getProperty("native.image.path");
        if (path == null) {
            path = NativeImageLauncher.guessPath(this.testClass);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(path);
        args.add("-Dquarkus.http.port=" + this.httpPort);
        args.add("-Dquarkus.http.ssl-port=" + this.httpsPort);
        args.add("-Dtest.url=" + TestHTTPResourceManager.getUri());
        Path logFile = PropertyTestUtil.getLogFilePath();
        args.add("-Dquarkus.log.file.path=" + logFile.toAbsolutePath().toString());
        args.add("-Dquarkus.log.file.enable=true");
        if (this.profile != null) {
            args.add("-Dquarkus.profile=" + this.profile);
        }
        for (Map.Entry<String, String> e : this.systemProps.entrySet()) {
            args.add("-D" + e.getKey() + "=" + e.getValue());
        }
        System.out.println("Executing " + args);
        Files.deleteIfExists(logFile);
        Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
        this.quarkusProcess = LauncherUtil.launchProcess(args);
        if (this.startedSupplier != null) {
            this.waitForStartedSupplier(this.quarkusProcess, this.startedSupplier, this.waitTimeSeconds);
        } else {
            ListeningAddress result = LauncherUtil.waitForCapturedListeningData(this.quarkusProcess, logFile, this.waitTimeSeconds);
            LauncherUtil.updateConfigForPort(result.getPort());
            this.isSsl = result.isSsl();
        }
    }

    private void waitForStartedSupplier(Process quarkusProcess, Supplier<Boolean> startedSupplier, long waitTime) {
        long bailout = System.currentTimeMillis() + waitTime * 1000L;
        boolean started = false;
        while (System.currentTimeMillis() < bailout) {
            if (!quarkusProcess.isAlive()) {
                throw new RuntimeException("Failed to start target quarkus application, process has exited");
            }
            try {
                Thread.sleep(100L);
                if (!startedSupplier.get().booleanValue()) continue;
                this.isSsl = false;
                started = true;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (!started) {
            quarkusProcess.destroyForcibly();
            throw new RuntimeException("Unable to start target quarkus application " + this.waitTimeSeconds + "s");
        }
    }

    private static String guessPath(Class<?> testClass) {
        ClassLoader cl = testClass.getClassLoader();
        if (cl instanceof URLClassLoader) {
            URL[] urls;
            for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
                String applicationNativeImagePath = NativeImageLauncher.guessPath(url);
                if (applicationNativeImagePath == null) continue;
                return applicationNativeImagePath;
            }
        } else {
            URL codeSourceLocation;
            String applicationNativeImagePath;
            CodeSource codeSource = testClass.getProtectionDomain().getCodeSource();
            if (codeSource != null && (applicationNativeImagePath = NativeImageLauncher.guessPath(codeSourceLocation = codeSource.getLocation())) != null) {
                return applicationNativeImagePath;
            }
        }
        throw new RuntimeException("Unable to automatically find native image, please set the native.image.path to the native executable you wish to test");
    }

    private static String guessPath(URL url) {
        block5: {
            block6: {
                block4: {
                    if (url == null) {
                        return null;
                    }
                    if (!url.getProtocol().equals("file") || !url.getPath().endsWith("test-classes/")) break block4;
                    File testClasses = new File(url.getPath());
                    for (File file : testClasses.getParentFile().listFiles()) {
                        if (!NativeImageLauncher.isNativeExecutable(file)) continue;
                        NativeImageLauncher.logGuessedPath(file.getAbsolutePath());
                        return file.getAbsolutePath();
                    }
                    break block5;
                }
                if (!url.getProtocol().equals("file") || !url.getPath().endsWith("test/")) break block6;
                File testClasses = new File(url.getPath());
                for (File file : testClasses.getParentFile().getParentFile().getParentFile().listFiles()) {
                    if (!NativeImageLauncher.isNativeExecutable(file)) continue;
                    NativeImageLauncher.logGuessedPath(file.getAbsolutePath());
                    return file.getAbsolutePath();
                }
                break block5;
            }
            if (!url.getProtocol().equals("file") || !url.getPath().contains("/target/surefire/")) break block5;
            String path = url.getPath();
            int index = path.lastIndexOf("/target/");
            File targetDir = new File(path.substring(0, index) + "/target/");
            for (File file : targetDir.listFiles()) {
                if (!NativeImageLauncher.isNativeExecutable(file)) continue;
                NativeImageLauncher.logGuessedPath(file.getAbsolutePath());
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    private static boolean isNativeExecutable(File file) {
        if (IS_WINDOWS) {
            return file.getName().endsWith("-runner.exe");
        }
        return file.getName().endsWith("-runner");
    }

    private static void logGuessedPath(String guessedPath) {
        System.err.println("======================================================================================");
        System.err.println("  native.image.path was not set, making a guess for the correct path of native image");
        System.err.println("  guessed path: " + guessedPath);
        System.err.println("======================================================================================");
    }

    @Override
    public boolean listensOnSsl() {
        return this.isSsl;
    }

    @Override
    public void addSystemProperties(Map<String, String> systemProps) {
        this.systemProps.putAll(systemProps);
    }

    @Override
    public void close() {
        this.quarkusProcess.destroy();
    }
}

