/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.web.resteasy.reactive.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.resteasy.reactive.server.spi.AnnotationsTransformerBuildItem;
import io.quarkus.resteasy.reactive.server.spi.MethodScannerBuildItem;
import io.quarkus.resteasy.reactive.spi.AdditionalResourceClassBuildItem;
import io.quarkus.resteasy.reactive.spi.ExceptionMapperBuildItem;
import io.quarkus.resteasy.server.common.spi.AdditionalJaxRsResourceMethodParamAnnotations;
import io.quarkus.spring.web.resteasy.reactive.runtime.ResponseEntityHandler;
import io.quarkus.spring.web.resteasy.reactive.runtime.ResponseStatusHandler;
import io.quarkus.spring.web.resteasy.reactive.runtime.SpringMapParamExtractor;
import io.quarkus.spring.web.resteasy.reactive.runtime.SpringMultiValueListParamExtractor;
import io.quarkus.spring.web.resteasy.reactive.runtime.SpringMultiValueMapParamExtractor;
import io.quarkus.spring.web.resteasy.reactive.runtime.SpringRequestParamHandler;
import io.quarkus.spring.web.runtime.common.ResponseStatusExceptionMapper;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ResteasyReactiveScanner;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationsTransformer;
import org.jboss.resteasy.reactive.common.processor.transformation.Transformation;
import org.jboss.resteasy.reactive.server.core.parameters.ParameterExtractor;
import org.jboss.resteasy.reactive.server.model.FixedHandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ResponseStatusException;

public class SpringWebResteasyReactiveProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)SpringWebResteasyReactiveProcessor.class.getName());
    private static final DotName REST_CONTROLLER_ANNOTATION = DotName.createSimple((String)"org.springframework.web.bind.annotation.RestController");
    private static final DotName REQUEST_MAPPING = DotName.createSimple((String)"org.springframework.web.bind.annotation.RequestMapping");
    private static final DotName GET_MAPPING = DotName.createSimple((String)"org.springframework.web.bind.annotation.GetMapping");
    private static final DotName POST_MAPPING = DotName.createSimple((String)"org.springframework.web.bind.annotation.PostMapping");
    private static final DotName PUT_MAPPING = DotName.createSimple((String)"org.springframework.web.bind.annotation.PutMapping");
    private static final DotName DELETE_MAPPING = DotName.createSimple((String)"org.springframework.web.bind.annotation.DeleteMapping");
    private static final DotName PATCH_MAPPING = DotName.createSimple((String)"org.springframework.web.bind.annotation.PatchMapping");
    private static final List<DotName> MAPPING_ANNOTATIONS = List.of(REQUEST_MAPPING, GET_MAPPING, POST_MAPPING, PUT_MAPPING, DELETE_MAPPING, PATCH_MAPPING);
    private static final DotName PATH_VARIABLE = DotName.createSimple((String)"org.springframework.web.bind.annotation.PathVariable");
    private static final DotName REQUEST_PARAM = DotName.createSimple((String)"org.springframework.web.bind.annotation.RequestParam");
    private static final DotName REQUEST_HEADER = DotName.createSimple((String)"org.springframework.web.bind.annotation.RequestHeader");
    private static final DotName COOKIE_VALUE = DotName.createSimple((String)"org.springframework.web.bind.annotation.CookieValue");
    private static final DotName MATRIX_VARIABLE = DotName.createSimple((String)"org.springframework.web.bind.annotation.MatrixVariable");
    private static final DotName RESPONSE_STATUS = DotName.createSimple((String)"org.springframework.web.bind.annotation.ResponseStatus");
    private static final DotName MODEL_AND_VIEW = DotName.createSimple((String)"org.springframework.web.servlet.ModelAndView");
    private static final DotName VIEW = DotName.createSimple((String)"org.springframework.web.servlet.View");
    private static final DotName MODEL = DotName.createSimple((String)"org.springframework.ui.Model");
    private static final DotName HTTP_ENTITY = DotName.createSimple((String)"org.springframework.http.HttpEntity");
    private static final DotName RESPONSE_ENTITY = DotName.createSimple((String)"org.springframework.http.ResponseEntity");
    private static final DotName SPRING_MULTIVALUE_MAP = DotName.createSimple((String)"org.springframework.util.MultiValueMap");
    private static final String DEFAULT_NONE = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n";
    public static final DotName JAVA_UTIL_LIST = DotName.createSimple((String)"java.util.List");
    public static final DotName JAVA_UTIL_MAP = DotName.createSimple((String)"java.util.Map");

    @BuildStep
    public AdditionalJaxRsResourceMethodParamAnnotations additionalJaxRsResourceMethodParamAnnotations() {
        return new AdditionalJaxRsResourceMethodParamAnnotations(Arrays.asList(DotName.createSimple((String)"org.springframework.web.bind.annotation.RequestParam"), PATH_VARIABLE, DotName.createSimple((String)"org.springframework.web.bind.annotation.RequestBody"), DotName.createSimple((String)"org.springframework.web.bind.annotation.MatrixVariable"), DotName.createSimple((String)"org.springframework.web.bind.annotation.RequestHeader"), DotName.createSimple((String)"org.springframework.web.bind.annotation.CookieValue")));
    }

    @BuildStep
    public void registerStandardExceptionMappers(BuildProducer<ExceptionMapperBuildItem> producer) {
        producer.produce((BuildItem)new ExceptionMapperBuildItem(ResponseStatusExceptionMapper.class.getName(), ResponseStatusException.class.getName(), Integer.valueOf(5000), false));
    }

    @BuildStep
    public void registerAdditionalResourceClasses(CombinedIndexBuildItem index, BuildProducer<AdditionalResourceClassBuildItem> additionalResourceClassProducer) {
        this.validateControllers(index.getIndex());
        for (AnnotationInstance restController : index.getIndex().getAnnotations(REST_CONTROLLER_ANNOTATION)) {
            ClassInfo targetClass = restController.target().asClass();
            additionalResourceClassProducer.produce((BuildItem)new AdditionalResourceClassBuildItem(targetClass, SpringWebResteasyReactiveProcessor.getSinglePathOfInstance(targetClass.declaredAnnotation(REQUEST_MAPPING), "")));
        }
    }

    private void validateControllers(IndexView index) {
        HashSet<DotName> classesWithoutRestController = new HashSet<DotName>();
        for (DotName mappingAnnotation : MAPPING_ANNOTATIONS) {
            Collection annotations = index.getAnnotations(mappingAnnotation);
            for (AnnotationInstance annotation : annotations) {
                ClassInfo targetClass;
                if (annotation.target().kind() == AnnotationTarget.Kind.CLASS) {
                    targetClass = annotation.target().asClass();
                } else {
                    if (annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                    targetClass = annotation.target().asMethod().declaringClass();
                }
                if (targetClass.declaredAnnotation(REST_CONTROLLER_ANNOTATION) != null) continue;
                classesWithoutRestController.add(targetClass.name());
            }
        }
        if (!classesWithoutRestController.isEmpty()) {
            for (DotName dotName : classesWithoutRestController) {
                LOGGER.warn((Object)("Class '" + String.valueOf(dotName) + "' uses a mapping annotation but the class itself was not annotated with '@RestController'. The mappings will therefore be ignored."));
            }
        }
    }

    private static String getSinglePathOfInstance(AnnotationInstance instance, String defaultPathValue) {
        String[] paths = SpringWebResteasyReactiveProcessor.getPathsOfInstance(instance);
        if (paths != null && paths.length > 0) {
            return paths[0];
        }
        return defaultPathValue;
    }

    private static String[] getPathsOfInstance(AnnotationInstance instance) {
        if (instance == null) {
            return null;
        }
        AnnotationValue pathValue = instance.value("path");
        if (pathValue != null) {
            return pathValue.asStringArray();
        }
        AnnotationValue value = instance.value();
        if (value != null) {
            return value.asStringArray();
        }
        return null;
    }

    private static String[] getStringArrayValueOfInstance(AnnotationInstance instance, String property) {
        if (instance == null) {
            return null;
        }
        AnnotationValue pathValue = instance.value(property);
        if (pathValue != null) {
            return pathValue.asStringArray();
        }
        return null;
    }

    @BuildStep
    public void methodAnnotationsTransformer(BuildProducer<AnnotationsTransformerBuildItem> producer) {
        producer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.METHOD;
            }

            public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                AnnotationTarget target = transformationContext.getTarget();
                if (target.kind() != AnnotationTarget.Kind.METHOD) {
                    return;
                }
                MethodInfo methodInfo = target.asMethod();
                Transformation transform = transformationContext.transform();
                DotName jaxRSMethodAnnotation = null;
                String path = null;
                String[] produces = null;
                String[] consumes = null;
                AnnotationInstance mappingAnnotationInstance = methodInfo.annotation(REQUEST_MAPPING);
                if (mappingAnnotationInstance != null) {
                    AnnotationValue methodValue = mappingAnnotationInstance.value("method");
                    if (methodValue == null) {
                        jaxRSMethodAnnotation = ResteasyReactiveDotNames.GET;
                    } else {
                        String[] methods = methodValue.asEnumArray();
                        if (methods.length > 1) {
                            throw new IllegalArgumentException("Usage of multiple methods using '@RequestMapping' is not allowed. Offending method is '" + String.valueOf(methodInfo.declaringClass().name()) + "#" + methodInfo.name() + "'");
                        }
                        DotName methodDotName = (DotName)ResteasyReactiveScanner.METHOD_TO_BUILTIN_HTTP_ANNOTATIONS.get(methods[0]);
                        if (methodDotName == null) {
                            throw new IllegalArgumentException("Unsupported HTTP method '" + methods[0] + "' for @RequestMapping. Offending method is '" + String.valueOf(methodInfo.declaringClass().name()) + "#" + methodInfo.name() + "'");
                        }
                        jaxRSMethodAnnotation = methodDotName;
                    }
                } else if (methodInfo.hasAnnotation(GET_MAPPING)) {
                    jaxRSMethodAnnotation = ResteasyReactiveDotNames.GET;
                    mappingAnnotationInstance = methodInfo.annotation(GET_MAPPING);
                } else if (methodInfo.hasAnnotation(POST_MAPPING)) {
                    jaxRSMethodAnnotation = ResteasyReactiveDotNames.POST;
                    mappingAnnotationInstance = methodInfo.annotation(POST_MAPPING);
                } else if (methodInfo.hasAnnotation(PUT_MAPPING)) {
                    jaxRSMethodAnnotation = ResteasyReactiveDotNames.PUT;
                    mappingAnnotationInstance = methodInfo.annotation(PUT_MAPPING);
                } else if (methodInfo.hasAnnotation(DELETE_MAPPING)) {
                    jaxRSMethodAnnotation = ResteasyReactiveDotNames.DELETE;
                    mappingAnnotationInstance = methodInfo.annotation(DELETE_MAPPING);
                } else if (methodInfo.hasAnnotation(PATCH_MAPPING)) {
                    jaxRSMethodAnnotation = ResteasyReactiveDotNames.PATCH;
                    mappingAnnotationInstance = methodInfo.annotation(PATCH_MAPPING);
                }
                if (jaxRSMethodAnnotation == null) {
                    return;
                }
                produces = SpringWebResteasyReactiveProcessor.getStringArrayValueOfInstance(mappingAnnotationInstance, "produces");
                consumes = SpringWebResteasyReactiveProcessor.getStringArrayValueOfInstance(mappingAnnotationInstance, "consumes");
                path = SpringWebResteasyReactiveProcessor.getSinglePathOfInstance(mappingAnnotationInstance, null);
                transform.add(jaxRSMethodAnnotation, new AnnotationValue[0]);
                this.addStringArrayValuedAnnotation(transform, target, consumes, ResteasyReactiveDotNames.CONSUMES);
                this.addStringArrayValuedAnnotation(transform, target, produces, ResteasyReactiveDotNames.PRODUCES);
                this.addPathAnnotation(transform, target, path);
                for (AnnotationInstance annotation : methodInfo.annotations()) {
                    if (annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER) continue;
                    DotName annotationName = annotation.name();
                    if (annotationName.equals((Object)REQUEST_PARAM) || annotationName.equals((Object)REQUEST_HEADER) || annotationName.equals((Object)COOKIE_VALUE) || annotationName.equals((Object)MATRIX_VARIABLE)) {
                        DotName jaxRsAnnotation = annotationName.equals((Object)REQUEST_PARAM) ? ResteasyReactiveDotNames.REST_QUERY_PARAM : (annotationName.equals((Object)REQUEST_HEADER) ? ResteasyReactiveDotNames.REST_QUERY_PARAM : (annotationName.equals((Object)COOKIE_VALUE) ? ResteasyReactiveDotNames.REST_COOKIE_PARAM : ResteasyReactiveDotNames.REST_MATRIX_PARAM));
                        String name = this.getNameOrDefaultFromParamAnnotation(annotation);
                        List<Object> annotationValues = name == null ? Collections.emptyList() : Collections.singletonList(AnnotationValue.createStringValue((String)"value", (String)name));
                        transform.add(AnnotationInstance.create((DotName)jaxRsAnnotation, (AnnotationTarget)annotation.target(), annotationValues));
                        String defaultValueStr = null;
                        AnnotationValue defaultValue = annotation.value("defaultValue");
                        if (defaultValue != null) {
                            defaultValueStr = defaultValue.asString();
                        } else {
                            AnnotationValue requiredValue = annotation.value("required");
                            if (requiredValue != null && requiredValue.asBoolean()) {
                                throw new IllegalArgumentException("Using required @RequestMapping is not supported. Offending method is '" + String.valueOf(methodInfo.declaringClass().name()) + "#" + methodInfo.name() + "'");
                            }
                        }
                        if (defaultValueStr == null) continue;
                        transform.add(AnnotationInstance.create((DotName)ResteasyReactiveDotNames.DEFAULT_VALUE, (AnnotationTarget)annotation.target(), Collections.singletonList(AnnotationValue.createStringValue((String)"value", (String)defaultValueStr))));
                        continue;
                    }
                    if (!annotationName.equals((Object)PATH_VARIABLE)) continue;
                    String name = this.getNameOrDefaultFromParamAnnotation(annotation);
                    List<Object> annotationValues = Collections.emptyList();
                    if (name != null) {
                        annotationValues = Collections.singletonList(AnnotationValue.createStringValue((String)"value", (String)name));
                    }
                    transform.add(AnnotationInstance.create((DotName)ResteasyReactiveDotNames.REST_PATH_PARAM, (AnnotationTarget)annotation.target(), annotationValues));
                }
                transform.done();
            }

            private String getNameOrDefaultFromParamAnnotation(AnnotationInstance annotation) {
                AnnotationValue nameValue = annotation.value("name");
                if (nameValue != null) {
                    return nameValue.asString();
                }
                AnnotationValue value = annotation.value();
                if (value != null) {
                    return value.asString();
                }
                return null;
            }

            private void addStringArrayValuedAnnotation(Transformation transform, AnnotationTarget target, String[] value, DotName annotationDotName) {
                if (value != null && value.length > 0) {
                    AnnotationValue[] values = new AnnotationValue[value.length];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = AnnotationValue.createStringValue((String)"", (String)value[i]);
                    }
                    transform.add(AnnotationInstance.create((DotName)annotationDotName, (AnnotationTarget)target, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createArrayValue((String)"value", (AnnotationValue[])values)}));
                }
            }

            private void addPathAnnotation(Transformation transform, AnnotationTarget target, String path) {
                if (path == null) {
                    return;
                }
                transform.add(AnnotationInstance.create((DotName)ResteasyReactiveDotNames.PATH, (AnnotationTarget)target, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)this.replaceSpringWebWildcards(path))}));
            }

            private String replaceSpringWebWildcards(String methodPath) {
                String[] parts;
                if (methodPath.contains("/**")) {
                    methodPath = methodPath.replace("/**", "{unsetPlaceHolderVar:.*}");
                }
                if (methodPath.contains("/*")) {
                    methodPath = methodPath.replace("/*", "/{unusedPlaceHolderVar}");
                }
                if ((parts = methodPath.split("/")).length > 0) {
                    StringBuilder sb = new StringBuilder(methodPath.startsWith("/") ? "/" : "");
                    for (int i = 0; i < parts.length; ++i) {
                        String part = parts[i];
                        if (part.isEmpty()) continue;
                        if (!sb.toString().endsWith("/")) {
                            sb.append("/");
                        }
                        if (part.startsWith("{") && part.endsWith("}") || !part.contains("?")) {
                            sb.append(part);
                            continue;
                        }
                        sb.append(String.format("{notusedPlaceHolderVar%s:", i)).append(part.replace('?', '.')).append("}");
                    }
                    if (methodPath.endsWith("/")) {
                        sb.append("/");
                    }
                    methodPath = sb.toString();
                }
                return methodPath;
            }
        }));
    }

    @BuildStep
    MethodScannerBuildItem scanner() {
        return new MethodScannerBuildItem(new MethodScanner(){

            public List<HandlerChainCustomizer> scan(MethodInfo method, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
                if (methodContext.containsKey("RequestParam")) {
                    for (MethodParameterInfo parameterInfo : method.parameters()) {
                        if (parameterInfo.annotation(REQUEST_PARAM) == null) continue;
                        AnnotationInstance annotation = parameterInfo.annotation(REQUEST_PARAM);
                        boolean required = annotation.value("required") == null || annotation.value("required").asBoolean();
                        String defaultValue = annotation.value("defaultValue") != null ? annotation.value("defaultValue").asString() : "";
                        boolean isOptional = parameterInfo.type().name().equals((Object)DotName.createSimple((String)Optional.class.getName()));
                        if (!required || !defaultValue.isBlank() || isOptional) continue;
                        return Collections.singletonList(new SpringRequestParamHandler());
                    }
                }
                return Collections.emptyList();
            }

            public ParameterExtractor handleCustomParameter(Type paramType, Map<DotName, AnnotationInstance> annotations, boolean field, Map<String, Object> methodContext) {
                if (annotations.containsKey(REQUEST_PARAM)) {
                    methodContext.put("RequestParam", true);
                    if (paramType.name().equals((Object)SPRING_MULTIVALUE_MAP)) {
                        return new SpringMultiValueMapParamExtractor();
                    }
                    if (paramType.name().equals((Object)JAVA_UTIL_LIST)) {
                        return new SpringMultiValueListParamExtractor();
                    }
                    if (paramType.name().equals((Object)JAVA_UTIL_MAP)) {
                        return new SpringMapParamExtractor();
                    }
                }
                return null;
            }
        });
    }

    @BuildStep
    public MethodScannerBuildItem responseEntitySupport() {
        return new MethodScannerBuildItem(new MethodScanner(){

            public List<HandlerChainCustomizer> scan(MethodInfo method, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
                DotName returnTypeName = method.returnType().name();
                if (returnTypeName.equals((Object)RESPONSE_ENTITY)) {
                    return Collections.singletonList(new FixedHandlerChainCustomizer((ServerRestHandler)new ResponseEntityHandler(), HandlerChainCustomizer.Phase.AFTER_METHOD_INVOKE));
                }
                return Collections.emptyList();
            }
        });
    }

    @BuildStep
    public MethodScannerBuildItem responseStatusSupport() {
        return new MethodScannerBuildItem(new MethodScanner(){

            public List<HandlerChainCustomizer> scan(MethodInfo method, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
                AnnotationInstance responseStatus = method.annotation(RESPONSE_STATUS);
                if (responseStatus != null) {
                    int newStatus = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
                    AnnotationValue codeValue = responseStatus.value("code");
                    if (codeValue != null) {
                        newStatus = HttpStatus.valueOf((String)codeValue.asEnum()).value();
                    } else {
                        AnnotationValue value = responseStatus.value();
                        if (value != null) {
                            newStatus = HttpStatus.valueOf((String)value.asEnum()).value();
                        }
                    }
                    ResponseStatusHandler handler = new ResponseStatusHandler();
                    handler.setNewResponseCode(newStatus);
                    handler.setDefaultResponseCode(method.returnType().kind() != Type.Kind.VOID ? Response.Status.OK.getStatusCode() : Response.Status.NO_CONTENT.getStatusCode());
                    return Collections.singletonList(new FixedHandlerChainCustomizer((ServerRestHandler)handler, HandlerChainCustomizer.Phase.AFTER_RESPONSE_CREATED));
                }
                return Collections.emptyList();
            }
        });
    }
}

