/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.web.runtime.common;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ResponseStatusException;

public class ResponseStatusExceptionMapper
implements ExceptionMapper<ResponseStatusException> {
    public Response toResponse(ResponseStatusException exception) {
        Response.ResponseBuilder responseBuilder = Response.status((int)exception.getStatusCode().value());
        this.addHeaders(responseBuilder, exception.getHeaders());
        return responseBuilder.entity((Object)exception.getMessage()).type("text/plain").build();
    }

    private void addHeaders(Response.ResponseBuilder responseBuilder, HttpHeaders springHeaders) {
        for (Map.Entry entry : springHeaders.entrySet()) {
            for (String headerValue : (List)entry.getValue()) {
                responseBuilder.header((String)entry.getKey(), (Object)headerValue);
            }
        }
    }
}

