/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.security.runtime.interceptor.check;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ClientProxy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.function.Supplier;

public class FromBeanRoleSupplier
implements Supplier<String[]> {
    private final Class<?> beanClass;
    private final Field field;

    public FromBeanRoleSupplier(Class<?> beanClass, String fieldName) {
        this.beanClass = beanClass;
        try {
            this.field = beanClass.getField(fieldName);
            if (this.field.getType() != String.class) {
                throw new RuntimeException("Field was not of type String");
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] get() {
        Object instance = Arc.container().select(this.beanClass, new Annotation[0]).get();
        if (instance instanceof ClientProxy) {
            instance = ((ClientProxy)instance).arc_contextualInstance();
        }
        try {
            return new String[]{(String)this.field.get(instance)};
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

