/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.security.runtime.interceptor.check;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import java.lang.reflect.Method;
import java.util.List;

public class AnyDelegatingSecurityCheck
implements SecurityCheck {
    private final List<SecurityCheck> securityChecks;

    public AnyDelegatingSecurityCheck(List<SecurityCheck> securityChecks) {
        this.securityChecks = securityChecks;
    }

    public void apply(SecurityIdentity identity, Method method, Object[] parameters) {
        SecurityException thrownException = null;
        for (SecurityCheck securityCheck : this.securityChecks) {
            try {
                securityCheck.apply(identity, method, parameters);
                return;
            }
            catch (SecurityException e) {
                thrownException = e;
            }
        }
        if (thrownException != null) {
            throw thrownException;
        }
    }

    public void apply(SecurityIdentity identity, MethodDescription methodDescription, Object[] parameters) {
        SecurityException thrownException = null;
        for (SecurityCheck securityCheck : this.securityChecks) {
            try {
                securityCheck.apply(identity, methodDescription, parameters);
                return;
            }
            catch (SecurityException e) {
                thrownException = e;
            }
        }
        if (thrownException != null) {
            throw thrownException;
        }
    }
}

