/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.security.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.spring.security.deployment.DotNames;
import io.quarkus.spring.security.deployment.SpringSecurityProcessorUtil;
import io.quarkus.spring.security.runtime.interceptor.check.AbstractBeanMethodSecurityCheck;
import java.lang.reflect.Modifier;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

class BeanMethodInvocationGenerator {
    private static final String METHOD_PARAMETER_REGEX = "#(\\w+)";
    private static final Pattern METHOD_PARAMETER_PATTERN = Pattern.compile("#(\\w+)");
    private final IndexView index;
    private final Map<String, DotName> springBeansNameToDotName;
    private final Map<String, ClassInfo> springBeansNameToClassInfo;
    private final Set<String> beansReferencedInPreAuthorized;
    private final ClassOutput classOutput;
    private final Map<String, String> alreadyGeneratedClasses = new HashMap<String, String>();

    public BeanMethodInvocationGenerator(IndexView index, Map<String, DotName> springBeansNameToDotName, Map<String, ClassInfo> springBeansNameToClassInfo, Set<String> beansReferencedInPreAuthorized, ClassOutput classOutput) {
        this.index = index;
        this.springBeansNameToDotName = springBeansNameToDotName;
        this.springBeansNameToClassInfo = springBeansNameToClassInfo;
        this.beansReferencedInPreAuthorized = beansReferencedInPreAuthorized;
        this.classOutput = classOutput;
    }

    final String generateSecurityCheck(String expression, MethodInfo securedMethodInfo) {
        String cacheKey;
        String cachedGeneratedClassName;
        String paramTypesDescriptor = this.getParamTypesDescriptor(securedMethodInfo);
        int parametersStartIndex = expression.indexOf(40);
        int parametersEndIndex = expression.indexOf(41);
        String[] beanMethodArgumentExpressions = new String[]{};
        if (parametersEndIndex > parametersStartIndex + 1) {
            beanMethodArgumentExpressions = expression.substring(parametersStartIndex + 1, parametersEndIndex).trim().split("\\s*,\\s*");
        }
        if ((cachedGeneratedClassName = this.alreadyGeneratedClasses.get(cacheKey = beanMethodArgumentExpressions.length > 0 ? expression + "-" + paramTypesDescriptor : expression)) != null) {
            return cachedGeneratedClassName;
        }
        Matcher matcher = SpringSecurityProcessorUtil.BASIC_BEAN_METHOD_INVOCATION_PATTERN.matcher(expression);
        if (!matcher.find()) {
            throw SpringSecurityProcessorUtil.createGenericMalformedException(securedMethodInfo, expression);
        }
        String beanName = matcher.group(1);
        ClassInfo beanClassInfo = SpringSecurityProcessorUtil.getClassInfoFromBeanName(beanName, this.index, this.springBeansNameToDotName, this.springBeansNameToClassInfo, expression, securedMethodInfo);
        String beanMethodName = matcher.group(2);
        MethodInfo matchingBeanMethod = this.determineMatchingBeanMethod(beanMethodName, beanMethodArgumentExpressions.length, beanClassInfo, securedMethodInfo, expression, beanName);
        String generatedClassName = "io.quarkus.spring.security.check." + beanClassInfo.name().withoutPackagePrefix() + "_" + HashUtil.sha1((String)cacheKey) + "_CheckFor_" + beanMethodName;
        try (ClassCreator cc = ClassCreator.builder().classOutput(this.classOutput).className(generatedClassName).superClass(AbstractBeanMethodSecurityCheck.class).build();){
            FieldDescriptor instanceField = FieldDescriptor.of((String)generatedClassName, (String)"INSTANCE", (String)generatedClassName);
            cc.getFieldCreator(instanceField).setModifiers(10);
            try (MethodCreator getInstance = (MethodCreator)cc.getMethodCreator("getInstance", generatedClassName, new String[0]).setModifiers(9);){
                ResultHandle instance = getInstance.readStaticField(instanceField);
                BranchResult instanceNullBranch = getInstance.ifNull(instance);
                instanceNullBranch.falseBranch().returnValue(instance);
                BytecodeCreator instanceNullTrue = instanceNullBranch.trueBranch();
                ResultHandle newInstance = instanceNullTrue.newInstance(MethodDescriptor.ofConstructor((String)generatedClassName, (String[])new String[0]), new ResultHandle[0]);
                instanceNullTrue.writeStaticField(instanceField, newInstance);
                instanceNullTrue.returnValue(newInstance);
            }
            try (MethodCreator check = (MethodCreator)cc.getMethodCreator("check", Boolean.TYPE, new Class[]{SecurityIdentity.class, Object[].class}).setModifiers(4);){
                ResultHandle arcContainer = check.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle instanceHandle = check.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{String.class}), arcContainer, new ResultHandle[]{check.load(beanName)});
                ResultHandle bean = check.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
                ResultHandle castedBean = check.checkCast(bean, beanClassInfo.name().toString());
                ResultHandle[] argHandles = new ResultHandle[beanMethodArgumentExpressions.length];
                for (int i = 0; i < beanMethodArgumentExpressions.length; ++i) {
                    String argumentExpression = beanMethodArgumentExpressions[i];
                    String trimmedArgumentExpression = argumentExpression.trim();
                    if (argumentExpression.startsWith("'") && argumentExpression.endsWith("'")) {
                        if (!DotNames.STRING.equals((Object)matchingBeanMethod.parameterType(i).name())) {
                            throw new IllegalArgumentException("Parameter with index " + i + " of method '" + beanMethodName + "' found in expression '" + trimmedArgumentExpression + "' in the @PreAuthorize annotation on method " + securedMethodInfo.name() + " of class " + String.valueOf(securedMethodInfo.declaringClass()) + " is not of type String");
                        }
                        argHandles[i] = check.load(argumentExpression.replace("'", ""));
                        continue;
                    }
                    if (trimmedArgumentExpression.matches(METHOD_PARAMETER_REGEX)) {
                        Matcher parameterMatcher = METHOD_PARAMETER_PATTERN.matcher(trimmedArgumentExpression);
                        if (!parameterMatcher.find()) {
                            throw SpringSecurityProcessorUtil.createGenericMalformedException(securedMethodInfo, expression);
                        }
                        int parameterIndex = SpringSecurityProcessorUtil.getParameterIndex(securedMethodInfo, parameterMatcher.group(1), expression);
                        DotName expectedType = securedMethodInfo.parameterType(parameterIndex).name();
                        if (!matchingBeanMethod.parameterType(i).name().equals((Object)expectedType)) {
                            throw new IllegalArgumentException("Parameter with index " + i + " of method '" + beanMethodName + "' found in expression '" + trimmedArgumentExpression + "' in the @PreAuthorize annotation on method " + securedMethodInfo.name() + " of class " + String.valueOf(securedMethodInfo.declaringClass()) + " is not of type " + String.valueOf(expectedType));
                        }
                        ResultHandle methodArgsArrays = check.getMethodParam(1);
                        argHandles[i] = check.readArrayValue(methodArgsArrays, parameterIndex);
                        continue;
                    }
                    if (trimmedArgumentExpression.matches("(authentication.)?principal.username")) {
                        ResultHandle username;
                        ResultHandle securityIdentity = check.getMethodParam(0);
                        ResultHandle principal = check.invokeInterfaceMethod(MethodDescriptor.ofMethod(SecurityIdentity.class, (String)"getPrincipal", Principal.class, (Class[])new Class[0]), securityIdentity, new ResultHandle[0]);
                        if (!DotNames.STRING.equals((Object)matchingBeanMethod.parameterType(i).name())) {
                            throw new IllegalArgumentException("Parameter with index " + i + " of method '" + beanMethodName + "' found in expression '" + trimmedArgumentExpression + "' in the @PreAuthorize annotation on method " + securedMethodInfo.name() + " of class " + String.valueOf(securedMethodInfo.declaringClass()) + " is not of type String");
                        }
                        argHandles[i] = username = check.invokeInterfaceMethod(MethodDescriptor.ofMethod(Principal.class, (String)"getName", String.class, (Class[])new Class[0]), principal, new ResultHandle[0]);
                        continue;
                    }
                    throw SpringSecurityProcessorUtil.createGenericMalformedException(securedMethodInfo, expression);
                }
                ResultHandle result = Modifier.isInterface(matchingBeanMethod.declaringClass().flags()) ? check.invokeInterfaceMethod(MethodDescriptor.of((MethodInfo)matchingBeanMethod), castedBean, argHandles) : check.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)matchingBeanMethod), castedBean, argHandles);
                check.returnValue(result);
            }
        }
        this.beansReferencedInPreAuthorized.add(beanClassInfo.name().toString());
        this.alreadyGeneratedClasses.put(cacheKey, generatedClassName);
        return generatedClassName;
    }

    private String getParamTypesDescriptor(MethodInfo securedMethodInfo) {
        StringBuilder sb = new StringBuilder("(");
        for (Type type : securedMethodInfo.parameterTypes()) {
            sb.append(DescriptorUtils.objectToDescriptor((Object)type.name().toString()));
        }
        sb.append(")");
        return sb.toString();
    }

    private MethodInfo determineMatchingBeanMethod(String methodName, int methodParametersSize, ClassInfo beanClassInfo, MethodInfo securedMethodInfo, String expression, String beanName) {
        MethodInfo matchingBeanClassMethod = null;
        for (MethodInfo candidateMethod : beanClassInfo.methods()) {
            if (!candidateMethod.name().equals(methodName) || !Modifier.isPublic(candidateMethod.flags()) || !DotNames.PRIMITIVE_BOOLEAN.equals((Object)candidateMethod.returnType().name()) || candidateMethod.parametersCount() != methodParametersSize) continue;
            if (matchingBeanClassMethod == null) {
                matchingBeanClassMethod = candidateMethod;
                continue;
            }
            throw new IllegalArgumentException("Could not match a unique method name '" + methodName + "' for bean named " + beanName + " with class " + String.valueOf(beanClassInfo.name()) + " Offending expression is " + expression + " of @PreAuthorize on method '" + methodName + "' of class " + String.valueOf(securedMethodInfo.declaringClass()));
        }
        if (matchingBeanClassMethod == null) {
            throw new IllegalArgumentException("Could not find a public, boolean returning method named '" + methodName + "' for bean named " + beanName + " with class " + String.valueOf(beanClassInfo.name()) + " Offending expression is " + expression + " of @PreAuthorize on method '" + methodName + "' of class " + String.valueOf(securedMethodInfo.declaringClass()));
        }
        return matchingBeanClassMethod;
    }
}

