/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.rest.deployment.crud;

import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.gizmo.MethodDescriptor;
import jakarta.persistence.Id;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

class EntityClassHelper {
    private final IndexView index;

    EntityClassHelper(IndexView index) {
        this.index = index;
    }

    FieldInfo getIdField(String className) {
        return this.getIdField(this.index.getClassByName(DotName.createSimple((String)className)));
    }

    private FieldInfo getIdField(ClassInfo classInfo) {
        ClassInfo tmpClassInfo = classInfo;
        while (tmpClassInfo != null) {
            for (FieldInfo field : tmpClassInfo.fields()) {
                if (!field.hasAnnotation(DotName.createSimple((String)Id.class.getName()))) continue;
                return field;
            }
            if (tmpClassInfo.superName() != null) {
                tmpClassInfo = this.index.getClassByName(tmpClassInfo.superName());
                continue;
            }
            tmpClassInfo = null;
        }
        throw new IllegalArgumentException("Couldn't find id field of " + String.valueOf(classInfo));
    }

    MethodDescriptor getSetter(String className, FieldInfo field) {
        return this.getSetter(this.index.getClassByName(DotName.createSimple((String)className)), field);
    }

    private MethodDescriptor getSetter(ClassInfo entityClass, FieldInfo field) {
        MethodDescriptor setter = this.getMethod(entityClass, JavaBeanUtil.getSetterName((String)field.name()), field.type());
        if (setter != null) {
            return setter;
        }
        return MethodDescriptor.ofMethod((Object)entityClass.toString(), (String)("$$_hibernate_write_" + field.name()), Void.TYPE, (Object[])new Object[]{field.type().name().toString()});
    }

    private MethodDescriptor getMethod(ClassInfo entityClass, String name, Type ... parameters) {
        if (entityClass == null) {
            return null;
        }
        MethodInfo methodInfo = entityClass.method(name, parameters);
        if (methodInfo != null) {
            return MethodDescriptor.of((MethodInfo)methodInfo);
        }
        if (entityClass.superName() != null) {
            return this.getMethod(this.index.getClassByName(entityClass.superName()), name, parameters);
        }
        return null;
    }
}

