/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.runtime;

import io.quarkus.hibernate.orm.panache.Panache;
import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.common.runtime.AbstractJpaOperations;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class RepositorySupport {
    private RepositorySupport() {
    }

    public static List<?> findByIds(AbstractJpaOperations<PanacheQuery<?>> operations, Class<?> entityClass, Iterable<?> ids) {
        Objects.requireNonNull(ids);
        ArrayList result = new ArrayList();
        ids.forEach(result::add);
        return operations.findByIds(entityClass, new ArrayList(result)).stream().filter(Objects::nonNull).toList();
    }

    public static void deleteAll(AbstractJpaOperations<PanacheQuery<?>> operations, Iterable<?> entities) {
        for (Object entity : entities) {
            operations.delete(entity);
        }
    }

    @Deprecated
    public static Object getOne(AbstractJpaOperations<PanacheQuery<?>> operations, Class<?> entityClass, Object id) {
        return RepositorySupport.getReferenceById(operations, entityClass, id);
    }

    @Deprecated
    public static Object getById(AbstractJpaOperations<PanacheQuery<?>> operations, Class<?> entityClass, Object id) {
        return RepositorySupport.getReferenceById(operations, entityClass, id);
    }

    public static Object getReferenceById(AbstractJpaOperations<PanacheQuery<?>> operations, Class<?> entityClass, Object id) {
        return operations.getSession(entityClass).getReference(entityClass, id);
    }

    public static void clear(Class<?> clazz) {
        Panache.getSession(clazz).clear();
    }

    public static void flush(Class<?> clazz) {
        Panache.getSession(clazz).flush();
    }
}

