/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.cloud.config.client.runtime;

import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.DurationConverter;
import io.quarkus.runtime.configuration.PathConverter;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@ConfigMapping(prefix="quarkus.spring-cloud-config")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface SpringCloudConfigClientConfig {
    @WithDefault(value="false")
    public boolean enabled();

    @WithDefault(value="false")
    public boolean failFast();

    @WithDefault(value="http://localhost:8888")
    public String url();

    @WithDefault(value="${quarkus.application.name:}")
    public String name();

    public Optional<String> label();

    @WithDefault(value="10S")
    @WithConverter(value=DurationConverter.class)
    public Duration connectionTimeout();

    @WithDefault(value="60S")
    @WithConverter(value=DurationConverter.class)
    public Duration readTimeout();

    public Optional<String> username();

    public Optional<String> password();

    public Optional<@WithConverter(value=PathConverter.class) Path> trustStore();

    public Optional<String> trustStorePassword();

    public Optional<@WithConverter(value=PathConverter.class) Path> keyStore();

    public Optional<String> keyStorePassword();

    public Optional<String> keyPassword();

    @WithDefault(value="${quarkus.tls.trust-all:false}")
    public boolean trustCerts();

    @ConfigDocMapKey(value="header-name")
    public Map<String, String> headers();

    public Optional<List<String>> profiles();

    @WithDefault(value="450")
    public int ordinal();

    public Optional<DiscoveryConfig> discovery();

    default public boolean usernameAndPasswordSet() {
        return this.username().isPresent() && this.password().isPresent();
    }

    public static interface DiscoveryConfig {
        @WithDefault(value="false")
        public boolean enabled();

        public Optional<String> serviceId();

        public Optional<EurekaConfig> eurekaConfig();

        public static interface EurekaConfig {
            public Map<String, String> serviceUrl();

            @WithDefault(value="30S")
            @WithConverter(value=DurationConverter.class)
            public Duration registryFetchIntervalSeconds();
        }
    }
}

