/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.cache;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.cache.deployment.spi.AdditionalCacheNameBuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.spring.cache.SpringCacheAnnotationsTransformer;
import io.quarkus.spring.cache.SpringCacheUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;

public class SpringCacheProcessor {
    static final DotName CACHEABLE = DotName.createSimple((String)Cacheable.class.getName());
    static final DotName CACHE_PUT = DotName.createSimple((String)CachePut.class.getName());
    static final DotName CACHE_EVICT = DotName.createSimple((String)CacheEvict.class.getName());
    private static final List<DotName> CACHE_ANNOTATIONS = List.of(CACHEABLE, CACHE_PUT, CACHE_EVICT);
    private static final Set<String> CURRENTLY_UNSUPPORTED_ANNOTATION_VALUES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("key", "keyGenerator", "cacheManager", "cacheResolver", "condition", "unless", "sync", "beforeInvocation")));

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.SPRING_CACHE));
    }

    @BuildStep
    AnnotationsTransformerBuildItem transform() {
        return new AnnotationsTransformerBuildItem((AnnotationsTransformer)new SpringCacheAnnotationsTransformer());
    }

    @BuildStep
    List<AdditionalCacheNameBuildItem> cacheNames(CombinedIndexBuildItem combinedIndex) {
        HashSet<String> cacheNames = new HashSet<String>();
        for (DotName cacheAnnotation : CACHE_ANNOTATIONS) {
            Collection instances = combinedIndex.getIndex().getAnnotations(cacheAnnotation);
            for (AnnotationInstance instance : instances) {
                this.validateUsage(instance);
                Optional<String> cacheName = SpringCacheUtil.getSpringCacheName(instance);
                if (!cacheName.isPresent()) continue;
                cacheNames.add(cacheName.get());
            }
        }
        ArrayList<AdditionalCacheNameBuildItem> result = new ArrayList<AdditionalCacheNameBuildItem>(cacheNames.size());
        for (String cacheName : cacheNames) {
            result.add(new AdditionalCacheNameBuildItem(cacheName));
        }
        return result;
    }

    private void validateUsage(AnnotationInstance instance) {
        if (instance.target().kind() != AnnotationTarget.Kind.METHOD) {
            throw new IllegalArgumentException("Currently Spring Cache annotations can only be added to methods. Offending instance is annotation '" + String.valueOf(instance) + "' on " + String.valueOf(instance.target()) + "'");
        }
        List values = instance.values();
        ArrayList<String> unsupportedValues = new ArrayList<String>();
        for (AnnotationValue value : values) {
            if (!CURRENTLY_UNSUPPORTED_ANNOTATION_VALUES.contains(value.name())) continue;
            unsupportedValues.add(value.name());
        }
        if (!unsupportedValues.isEmpty()) {
            throw new IllegalArgumentException("Annotation '" + String.valueOf(instance) + "' on '" + String.valueOf(instance.target()) + "' contains the following currently unsupported annotation values: " + String.join((CharSequence)", ", unsupportedValues));
        }
    }
}

