/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.boot.properties.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.StringUtil;
import io.smallrye.config.ConfigMapping;
import java.util.Iterator;
import java.util.function.BiFunction;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

final class ConfigurationPropertiesMetadataBuildItem
extends MultiBuildItem {
    private final ClassInfo classInfo;
    private final String prefix;
    private final ConfigMapping.NamingStrategy namingStrategy;
    private final boolean failOnMismatchingMember;
    private final InstanceFactory instanceFactory;

    public ConfigurationPropertiesMetadataBuildItem(ClassInfo classInfo, String prefix, ConfigMapping.NamingStrategy namingStrategy, boolean failOnMismatchingMember) {
        this(classInfo, prefix, namingStrategy, failOnMismatchingMember, null);
    }

    public ConfigurationPropertiesMetadataBuildItem(ClassInfo classInfo, String prefix, ConfigMapping.NamingStrategy namingStrategy, boolean failOnMismatchingMember, InstanceFactory instanceFactory) {
        this.classInfo = classInfo;
        this.prefix = this.sanitisePrefix(prefix);
        this.namingStrategy = namingStrategy;
        this.failOnMismatchingMember = failOnMismatchingMember;
        this.instanceFactory = instanceFactory;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ConfigMapping.NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public boolean isFailOnMismatchingMember() {
        return this.failOnMismatchingMember;
    }

    public InstanceFactory getInstanceFactory() {
        return this.instanceFactory;
    }

    private String sanitisePrefix(String prefix) {
        if (prefix == null) {
            return this.getPrefixFromClassName(this.classInfo.name());
        }
        return prefix;
    }

    private String getPrefixFromClassName(DotName className) {
        String simpleName = className.isInner() ? className.local() : className.withoutPackagePrefix();
        return String.join((CharSequence)"-", () -> StringUtil.withoutSuffix((Iterator)StringUtil.lowerCase((Iterator)StringUtil.camelHumpsIterator((String)simpleName)), (String[])new String[]{"config", "configuration", "properties", "props"}));
    }

    public static interface InstanceFactory
    extends BiFunction<MethodCreator, String, ResultHandle> {
    }
}

