/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment.filter;

import io.quarkus.smallrye.openapi.deployment.filter.ClassAndMethod;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;

public class OperationFilter
implements OASFilter {
    public static final String EXT_METHOD_REF = "x-quarkus-openapi-method-ref";
    private final Map<String, ClassAndMethod> classNameMap;
    private final Map<String, List<String>> authorizedMethodReferences;
    private final List<String> authenticatedMethodReferences;
    private final String defaultSecuritySchemeName;
    private final boolean doAutoTag;
    private final boolean doAutoOperation;
    private final boolean doAutoBadRequest;
    private final boolean alwaysIncludeScopesValidForScheme;

    public OperationFilter(Map<String, ClassAndMethod> classNameMap, Map<String, List<String>> authorizedMethodReferences, List<String> authenticatedMethodReferences, String defaultSecuritySchemeName, boolean doAutoTag, boolean doAutoOperation, boolean doAutoBadRequest, boolean alwaysIncludeScopesValidForScheme) {
        this.classNameMap = Objects.requireNonNull(classNameMap);
        this.authorizedMethodReferences = Objects.requireNonNull(authorizedMethodReferences);
        this.authenticatedMethodReferences = Objects.requireNonNull(authenticatedMethodReferences);
        this.defaultSecuritySchemeName = Objects.requireNonNull(defaultSecuritySchemeName);
        this.doAutoTag = doAutoTag;
        this.doAutoOperation = doAutoOperation;
        this.doAutoBadRequest = doAutoBadRequest;
        this.alwaysIncludeScopesValidForScheme = alwaysIncludeScopesValidForScheme;
    }

    /*
     * Unable to fully structure code
     */
    public void filterOpenAPI(OpenAPI openAPI) {
        securityScheme = this.getSecurityScheme(openAPI);
        schemeName = securityScheme.map((Function<Map.Entry, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getKey(), (Ljava/util/Map$Entry;)Ljava/lang/String;)()).orElse(this.defaultSecuritySchemeName);
        if (this.alwaysIncludeScopesValidForScheme) ** GOTO lbl-1000
        if (securityScheme.map((Function<Map.Entry, SecurityScheme>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Ljava/util/Map$Entry;)Lorg/eclipse/microprofile/openapi/models/security/SecurityScheme;)()).map((Function<SecurityScheme, SecurityScheme.Type>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getType(), (Lorg/eclipse/microprofile/openapi/models/security/SecurityScheme;)Lorg/eclipse/microprofile/openapi/models/security/SecurityScheme$Type;)()).map((Function<SecurityScheme.Type, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, contains(java.lang.Object ), (Lorg/eclipse/microprofile/openapi/models/security/SecurityScheme$Type;)Ljava/lang/Boolean;)(Set.of(SecurityScheme.Type.OAUTH2, SecurityScheme.Type.OPENIDCONNECT))).orElse(false).booleanValue()) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        scopesValidForScheme = v0;
        defaultSecurityErrors = this.getSecurityResponses();
        Optional.ofNullable(openAPI.getPaths()).map((Function<Paths, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPathItems(), (Lorg/eclipse/microprofile/openapi/models/Paths;)Ljava/util/Map;)()).map((Function<Map, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, entrySet(), (Ljava/util/Map;)Ljava/util/Set;)()).map((Function<Set, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(), (Ljava/util/Set;)Ljava/util/stream/Stream;)()).orElseGet((Supplier<Stream>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, empty(), ()Ljava/util/stream/Stream;)()).map((Function<Map.Entry, PathItem>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Ljava/util/Map$Entry;)Lorg/eclipse/microprofile/openapi/models/PathItem;)()).map((Function<PathItem, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getOperations(), (Lorg/eclipse/microprofile/openapi/models/PathItem;)Ljava/util/Map;)()).filter((Predicate<Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Ljava/util/Map;)Z)()).flatMap((Function<Map, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$filterOpenAPI$0(java.util.Map ), (Ljava/util/Map;)Ljava/util/stream/Stream;)()).forEach((Consumer<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$filterOpenAPI$1(java.lang.String boolean java.util.Map org.eclipse.microprofile.openapi.models.OpenAPI java.util.Map$Entry ), (Ljava/util/Map$Entry;)V)((OperationFilter)this, (String)schemeName, (boolean)scopesValidForScheme, defaultSecurityErrors, (OpenAPI)openAPI));
    }

    private String methodRef(Operation operation) {
        Map extensions = operation.getExtensions();
        return extensions != null ? extensions.get(EXT_METHOD_REF) : null;
    }

    private void maybeAddBadRequestResponse(OpenAPI openAPI, Map.Entry<PathItem.HttpMethod, Operation> operation, String methodRef) {
        if (!this.classNameMap.containsKey(methodRef)) {
            return;
        }
        if (this.doAutoBadRequest && this.isPOSTorPUT(operation) && this.hasBody(operation) && !this.isStringOrNumberOrBoolean(operation, openAPI) && !this.isFileUpload(operation, openAPI) && !operation.getValue().getResponses().hasAPIResponse("400")) {
            operation.getValue().getResponses().addAPIResponse("400", OASFactory.createAPIResponse().description("Bad Request"));
        }
    }

    private boolean isPOSTorPUT(Map.Entry<PathItem.HttpMethod, Operation> operation) {
        return operation.getKey().equals((Object)PathItem.HttpMethod.POST) || operation.getKey().equals((Object)PathItem.HttpMethod.PUT);
    }

    private boolean hasBody(Map.Entry<PathItem.HttpMethod, Operation> operation) {
        return operation.getValue().getRequestBody() != null;
    }

    private boolean isStringOrNumberOrBoolean(Map.Entry<PathItem.HttpMethod, Operation> operation, OpenAPI openAPI) {
        boolean isStringOrNumberOrBoolean = false;
        Content content = operation.getValue().getRequestBody().getContent();
        if (content != null) {
            for (MediaType mediaType : content.getMediaTypes().values()) {
                if (mediaType == null || mediaType.getSchema() == null) continue;
                Schema schema = mediaType.getSchema();
                if (schema.getRef() != null || schema.getContentSchema() != null && schema.getContentSchema().getRef() != null) {
                    schema = this.resolveSchema(schema, openAPI.getComponents());
                }
                if (!this.isString(schema) && !this.isNumber(schema) && !this.isBoolean(schema)) continue;
                isStringOrNumberOrBoolean = true;
            }
        }
        return isStringOrNumberOrBoolean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Schema resolveSchema(Schema schema, Components components) {
        while (schema != null) {
            if (schema.getRef() != null && components != null) {
                String refName = schema.getRef().replace("#/components/schemas/", "");
                schema = (Schema)components.getSchemas().get(refName);
                if (schema != null) return schema;
            }
            if (schema.getContentSchema() == null) return schema;
            schema = schema.getContentSchema();
        }
        return schema;
    }

    private boolean isFileUpload(Map.Entry<PathItem.HttpMethod, Operation> operation, OpenAPI openAPI) {
        boolean isFile = false;
        Content content = operation.getValue().getRequestBody().getContent();
        if (content != null) {
            for (Map.Entry kv : content.getMediaTypes().entrySet()) {
                MediaType mediaType;
                String mediaTypeKey = (String)kv.getKey();
                if (!"multipart/form-data".equals(mediaTypeKey) && !"application/octet-stream".equals(mediaTypeKey) || (mediaType = (MediaType)kv.getValue()) == null || mediaType.getSchema() == null || !this.isFileSchema(mediaType.getSchema(), openAPI.getComponents())) continue;
                isFile = true;
            }
        }
        return isFile;
    }

    private boolean isFileSchema(Schema schema, Components components) {
        if (this.isString(schema) && this.isBinaryFormat(schema)) {
            return true;
        }
        if (this.isObject(schema) && schema.getProperties() != null) {
            return schema.getProperties().values().stream().anyMatch(prop -> this.isString((Schema)prop) && this.isBinaryFormat((Schema)prop));
        }
        if (schema.getRef() != null && components != null) {
            String refName = schema.getRef().replace("#/components/schemas/", "");
            Schema referencedSchema = (Schema)components.getSchemas().get(refName);
            if (referencedSchema != null) {
                return this.isFileSchema(referencedSchema, components);
            }
        }
        return false;
    }

    private boolean isString(Schema schema) {
        return schema != null && schema.getType() != null && schema.getType().contains(Schema.SchemaType.STRING);
    }

    private boolean isNumber(Schema schema) {
        return schema != null && schema.getType() != null && (schema.getType().contains(Schema.SchemaType.INTEGER) || schema.getType().contains(Schema.SchemaType.NUMBER));
    }

    private boolean isBoolean(Schema schema) {
        return schema != null && schema.getType() != null && schema.getType().contains(Schema.SchemaType.BOOLEAN);
    }

    private boolean isObject(Schema schema) {
        return schema != null && schema.getType() != null && schema.getType().contains(Schema.SchemaType.OBJECT);
    }

    private boolean isBinaryFormat(Schema schema) {
        return "binary".equals(schema.getFormat());
    }

    private void maybeSetSummaryAndTag(Operation operation, String methodRef) {
        if (!this.classNameMap.containsKey(methodRef)) {
            return;
        }
        ClassAndMethod classMethod = this.classNameMap.get(methodRef);
        if (this.doAutoOperation && operation.getSummary() == null) {
            operation.setSummary(this.capitalizeFirstLetter(this.splitCamelCase(classMethod.method().name())));
        }
        if (this.doAutoTag && (operation.getTags() == null || operation.getTags().isEmpty())) {
            operation.addTag(this.splitCamelCase(classMethod.classInfo().simpleName()));
        }
    }

    private String splitCamelCase(String s) {
        return s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
    }

    private String capitalizeFirstLetter(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private void maybeAddSecurityRequirement(Operation operation, String methodRef, String schemeName, boolean allowScopes, Map<String, APIResponse> defaultSecurityErrors) {
        if (this.authorizedMethodReferences.containsKey(methodRef)) {
            List<String> scopes = this.authorizedMethodReferences.get(methodRef);
            this.addSecurityRequirement(operation, schemeName, allowScopes ? scopes : Collections.emptyList());
            this.addDefaultSecurityResponses(operation, defaultSecurityErrors);
        } else if (this.authenticatedMethodReferences.contains(methodRef)) {
            this.addSecurityRequirement(operation, schemeName, Collections.emptyList());
            this.addDefaultSecurityResponses(operation, defaultSecurityErrors);
        }
    }

    private Optional<Map.Entry<String, SecurityScheme>> getSecurityScheme(OpenAPI openAPI) {
        return Optional.ofNullable(openAPI.getComponents()).map(Components::getSecuritySchemes).map(Map::entrySet).map(Collection::stream).orElseGet(Stream::empty).findFirst();
    }

    private void addSecurityRequirement(Operation operation, String schemeName, List<String> scopes) {
        SecurityRequirement securityRequirement = OASFactory.createSecurityRequirement();
        securityRequirement = securityRequirement.addScheme(schemeName, scopes);
        operation.addSecurityRequirement(securityRequirement);
    }

    private void addDefaultSecurityResponses(Operation operation, Map<String, APIResponse> defaultSecurityErrors) {
        APIResponses responses = operation.getResponses();
        defaultSecurityErrors.entrySet().stream().filter(e -> !responses.hasAPIResponse((String)e.getKey())).forEach(e -> responses.addAPIResponse((String)e.getKey(), (APIResponse)e.getValue()));
    }

    private Map<String, APIResponse> getSecurityResponses() {
        LinkedHashMap<String, APIResponse> responses = new LinkedHashMap<String, APIResponse>();
        responses.put("401", OASFactory.createAPIResponse().description("Not Authorized"));
        responses.put("403", OASFactory.createAPIResponse().description("Not Allowed"));
        return responses;
    }

    private /* synthetic */ void lambda$filterOpenAPI$1(String schemeName, boolean scopesValidForScheme, Map defaultSecurityErrors, OpenAPI openAPI, Map.Entry operation) {
        String methodRef = this.methodRef((Operation)operation.getValue());
        if (methodRef != null) {
            this.maybeSetSummaryAndTag((Operation)operation.getValue(), methodRef);
            this.maybeAddSecurityRequirement((Operation)operation.getValue(), methodRef, schemeName, scopesValidForScheme, defaultSecurityErrors);
            this.maybeAddBadRequestResponse(openAPI, operation, methodRef);
        }
        ((Operation)operation.getValue()).removeExtension(EXT_METHOD_REF);
    }

    private static /* synthetic */ Stream lambda$filterOpenAPI$0(Map operations) {
        return operations.entrySet().stream();
    }
}

