/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.runtime.dev.ui;

import io.smallrye.health.SmallRyeHealth;
import io.smallrye.health.SmallRyeHealthReporter;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class HealthJsonRPCService {
    @Inject
    SmallRyeHealthReporter smallRyeHealthReporter;
    private final BroadcastProcessor<SmallRyeHealth> healthStream = BroadcastProcessor.create();
    private final BroadcastProcessor<String> statusStream = BroadcastProcessor.create();
    private final AtomicReference<String> lastPayload = new AtomicReference<String>("");
    private static final String UP_ICON = "<vaadin-icon style='color:var(--lumo-success-text-color);' icon='font-awesome-solid:thumbs-up'></vaadin-icon>";
    private static final String DOWN_ICON = "<vaadin-icon style='color:var(--lumo-error-text-color);' icon='font-awesome-solid:thumbs-down'></vaadin-icon>";

    @PostConstruct
    void startPolling() {
        Multi.createFrom().ticks().every(Duration.ofSeconds(3L)).onItem().transformToUniAndMerge(tick -> this.smallRyeHealthReporter.getHealthAsync()).subscribe().with(smallRyeHealth -> {
            String jsonStr = smallRyeHealth.getPayload().toString();
            if (!Objects.equals(this.lastPayload.getAndSet(jsonStr), jsonStr) && smallRyeHealth != null) {
                this.healthStream.onNext(smallRyeHealth);
                this.statusStream.onNext((Object)this.getStatusIcon((SmallRyeHealth)smallRyeHealth));
            }
        }, failure -> {
            JsonObject errorPayload = Json.createObjectBuilder().add("status", "DOWN").add("checks", Json.createArrayBuilder().add(Json.createObjectBuilder().add("name", "Smallrye Health stream").add("status", "DOWN").add("data", Json.createObjectBuilder().add("reason", failure.getMessage())))).build();
            this.healthStream.onNext((Object)new SmallRyeHealth(errorPayload));
            this.statusStream.onNext((Object)DOWN_ICON);
        });
    }

    public Uni<SmallRyeHealth> getHealth() {
        return this.smallRyeHealthReporter.getHealthAsync();
    }

    public Multi<SmallRyeHealth> streamHealth() {
        return this.healthStream;
    }

    public String getStatus() {
        return this.getStatusIcon(this.smallRyeHealthReporter.getHealth());
    }

    public Multi<String> streamStatus() {
        return this.statusStream;
    }

    private String getStatusIcon(SmallRyeHealth smallRyeHealth) {
        String status;
        if (smallRyeHealth.getPayload() != null && smallRyeHealth.getPayload().containsKey((Object)"status") && (status = smallRyeHealth.getPayload().getString("status")).equalsIgnoreCase("UP")) {
            return UP_ICON;
        }
        return DOWN_ICON;
    }
}

