/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import graphql.schema.GraphQLSchema;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.smallrye.graphql.runtime.ExtraScalar;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLCompressionHandler;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLConfig;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLExecutionHandler;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLNoEndpointHandler;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLOverWebSocketHandler;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLRuntimeConfig;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLSchemaHandler;
import io.quarkus.smallrye.graphql.runtime.spi.QuarkusClassloadingService;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.devmode.FileSystemStaticHandler;
import io.quarkus.vertx.http.runtime.webjar.WebJarNotFoundHandler;
import io.quarkus.vertx.http.runtime.webjar.WebJarStaticHandler;
import io.smallrye.graphql.cdi.producer.GraphQLProducer;
import io.smallrye.graphql.scalar.GraphQLScalarTypes;
import io.smallrye.graphql.schema.model.Schema;
import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.SubmissionPublisher;
import java.util.function.Consumer;

@Recorder
public class SmallRyeGraphQLRecorder {
    private final SmallRyeGraphQLConfig graphQLConfig;
    private final RuntimeValue<SmallRyeGraphQLRuntimeConfig> runtimeConfig;

    public SmallRyeGraphQLRecorder(SmallRyeGraphQLConfig graphQLConfig, RuntimeValue<SmallRyeGraphQLRuntimeConfig> runtimeConfig) {
        this.graphQLConfig = graphQLConfig;
        this.runtimeConfig = runtimeConfig;
    }

    public RuntimeValue<SubmissionPublisher<String>> createTraficLogPublisher() {
        return new RuntimeValue(new SubmissionPublisher());
    }

    public RuntimeValue<Boolean> createExecutionService(BeanContainer beanContainer, Schema schema, Optional<RuntimeValue<SubmissionPublisher<String>>> publisher) {
        GraphQLSchema graphQLSchema;
        GraphQLProducer graphQLProducer = (GraphQLProducer)beanContainer.beanInstance(GraphQLProducer.class, new Annotation[0]);
        if (this.graphQLConfig.extraScalars().isPresent()) {
            this.registerExtraScalars(this.graphQLConfig.extraScalars().get());
        }
        if (publisher.isPresent()) {
            graphQLProducer.setTraficPublisher((SubmissionPublisher)publisher.get().getValue());
        }
        return new RuntimeValue((Object)((graphQLSchema = graphQLProducer.initialize(schema)) != null ? 1 : 0));
    }

    private void registerExtraScalars(List<ExtraScalar> extraScalars) {
        for (ExtraScalar extraScalar : extraScalars) {
            switch (extraScalar) {
                case UUID: {
                    GraphQLScalarTypes.addUuid();
                    break;
                }
                case OBJECT: {
                    GraphQLScalarTypes.addObject();
                    break;
                }
                case JSON: {
                    GraphQLScalarTypes.addJson();
                }
            }
        }
    }

    public Handler<RoutingContext> executionHandler(RuntimeValue<Boolean> initialized, boolean allowGet, boolean allowPostWithQueryParameters, boolean runBlocking, boolean allowCompression) {
        if (((Boolean)initialized.getValue()).booleanValue()) {
            SmallRyeGraphQLExecutionHandler handler = new SmallRyeGraphQLExecutionHandler(allowGet, allowPostWithQueryParameters, runBlocking, this.getCurrentIdentityAssociation(), (CurrentVertxRequest)Arc.container().instance(CurrentVertxRequest.class, new Annotation[0]).get());
            if (allowCompression) {
                return new SmallRyeGraphQLCompressionHandler(handler);
            }
            return handler;
        }
        return new SmallRyeGraphQLNoEndpointHandler();
    }

    public Handler<RoutingContext> graphqlOverWebsocketHandler(BeanContainer beanContainer, RuntimeValue<Boolean> initialized, boolean runBlocking) {
        return new SmallRyeGraphQLOverWebSocketHandler(this.getCurrentIdentityAssociation(), (CurrentVertxRequest)Arc.container().instance(CurrentVertxRequest.class, new Annotation[0]).get(), runBlocking, this.graphQLConfig.authorizationClientInitPayloadName());
    }

    public Handler<RoutingContext> schemaHandler(RuntimeValue<Boolean> initialized, boolean schemaAvailable) {
        if (((Boolean)initialized.getValue()).booleanValue() && schemaAvailable) {
            return new SmallRyeGraphQLSchemaHandler();
        }
        return new SmallRyeGraphQLNoEndpointHandler();
    }

    public Handler<RoutingContext> uiHandler(String graphqlUiFinalDestination, String graphqlUiPath, List<FileSystemStaticHandler.StaticWebRootConfiguration> webRootConfigurations, ShutdownContext shutdownContext) {
        if (((SmallRyeGraphQLRuntimeConfig)this.runtimeConfig.getValue()).enable().orElse(((SmallRyeGraphQLRuntimeConfig)this.runtimeConfig.getValue()).enabled()).booleanValue()) {
            WebJarStaticHandler handler = new WebJarStaticHandler(graphqlUiFinalDestination, graphqlUiPath, webRootConfigurations);
            shutdownContext.addShutdownTask((Runnable)new ShutdownContext.CloseRunnable((Closeable)handler));
            return handler;
        }
        return new WebJarNotFoundHandler();
    }

    public void setupClDevMode(ShutdownContext shutdownContext) {
        QuarkusClassloadingService.setClassLoader(Thread.currentThread().getContextClassLoader());
        shutdownContext.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                QuarkusClassloadingService.setClassLoader(null);
            }
        });
    }

    public Consumer<Route> routeFunction(final Handler<RoutingContext> bodyHandler) {
        return new Consumer<Route>(){

            @Override
            public void accept(Route route) {
                route.handler(bodyHandler);
            }
        };
    }

    private CurrentIdentityAssociation getCurrentIdentityAssociation() {
        InstanceHandle identityAssociations = Arc.container().instance(CurrentIdentityAssociation.class, new Annotation[0]);
        if (identityAssociations.isAvailable()) {
            return (CurrentIdentityAssociation)identityAssociations.get();
        }
        return null;
    }
}

