/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.deployment.devui;

import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.ExternalPageBuilder;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLConfig;
import io.quarkus.smallrye.graphql.runtime.dev.GraphQLJsonRpcService;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;

public class SmallRyeGraphQLDevUIProcessor {
    SmallRyeGraphQLConfig graphQLConfig;

    @BuildStep(onlyIf={IsDevelopment.class})
    CardPageBuildItem createCard(NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        CardPageBuildItem cardPageBuildItem = new CardPageBuildItem();
        cardPageBuildItem.addLibraryVersion("io.smallrye", "smallrye-graphql-cdi", "SmallRye GraphQL", "https://smallrye.io/smallrye-graphql");
        cardPageBuildItem.addLibraryVersion("com.graphql-java", "graphql-java", "GraphQL Java", "https://www.graphql-java.com/");
        cardPageBuildItem.setLogo("logo_dark.svg", "logo_light.svg");
        String schemaPath = "/" + this.graphQLConfig.rootPath() + "/schema.graphql";
        ExternalPageBuilder schemaPage = ((ExternalPageBuilder)Page.externalPageBuilder((String)"GraphQL Schema").icon("font-awesome-solid:diagram-project")).url(schemaPath, schemaPath);
        String uiPath = nonApplicationRootPathBuildItem.resolvePath(this.graphQLConfig.ui().rootPath());
        ExternalPageBuilder uiPage = ((ExternalPageBuilder)Page.externalPageBuilder((String)"GraphQL UI").icon("font-awesome-solid:table-columns")).url(uiPath + "/index.html?embed=true", uiPath);
        ExternalPageBuilder learnLink = ((ExternalPageBuilder)Page.externalPageBuilder((String)"Learn more about GraphQL").icon("font-awesome-solid:graduation-cap")).doNotEmbed().url("https://graphql.org/");
        WebComponentPageBuilder assistantPage = ((WebComponentPageBuilder)Page.assistantPageBuilder().title("Generate clients")).componentLink("qwc-graphql-generate-client.js");
        cardPageBuildItem.addPage((PageBuilder)uiPage);
        cardPageBuildItem.addPage((PageBuilder)schemaPage);
        cardPageBuildItem.addPage((PageBuilder)learnLink);
        cardPageBuildItem.addPage((PageBuilder)assistantPage);
        return cardPageBuildItem;
    }

    @BuildStep
    JsonRPCProvidersBuildItem createJsonRPCService() {
        return new JsonRPCProvidersBuildItem(GraphQLJsonRpcService.class);
    }
}

