/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.webauthn.WebAuthnAuthenticationMechanism;
import io.quarkus.security.webauthn.WebAuthnController;
import io.quarkus.security.webauthn.WebAuthnRunTimeConfig;
import io.quarkus.security.webauthn.WebAuthnSecurity;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.quarkus.vertx.http.runtime.security.PersistentLoginManager;
import io.vertx.core.Handler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import java.lang.annotation.Annotation;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Base64;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class WebAuthnRecorder {
    private static final Logger log = Logger.getLogger(WebAuthnRecorder.class);
    final RuntimeValue<VertxHttpConfig> httpConfig;
    final RuntimeValue<WebAuthnRunTimeConfig> config;
    static volatile String encryptionKey;

    public WebAuthnRecorder(RuntimeValue<VertxHttpConfig> httpConfig, RuntimeValue<WebAuthnRunTimeConfig> config) {
        this.httpConfig = httpConfig;
        this.config = config;
    }

    public void setupRoutes(BeanContainer beanContainer, RuntimeValue<Router> routerValue, String prefix) {
        WebAuthnSecurity security = (WebAuthnSecurity)beanContainer.beanInstance(WebAuthnSecurity.class, new Annotation[0]);
        WebAuthnController controller = new WebAuthnController(security);
        Router router = (Router)routerValue.getValue();
        BodyHandler bodyHandler = BodyHandler.create();
        router.get(prefix + "webauthn/login-options-challenge").handler((Handler)bodyHandler).handler(controller::loginOptionsChallenge);
        router.get(prefix + "webauthn/register-options-challenge").handler((Handler)bodyHandler).handler(controller::registerOptionsChallenge);
        if (((WebAuthnRunTimeConfig)this.config.getValue()).enableLoginEndpoint().orElse(false).booleanValue()) {
            router.post(prefix + "webauthn/login").handler((Handler)bodyHandler).handler(controller::login);
        }
        if (((WebAuthnRunTimeConfig)this.config.getValue()).enableRegistrationEndpoint().orElse(false).booleanValue()) {
            router.post(prefix + "webauthn/register").handler((Handler)bodyHandler).handler(controller::register);
        }
        router.get(prefix + "webauthn/webauthn.js").handler(controller::javascript);
        router.get(prefix + "webauthn/logout").handler(controller::logout);
        router.get("/.well-known/webauthn").handler(controller::wellKnown);
    }

    public Supplier<WebAuthnAuthenticationMechanism> setupWebAuthnAuthenticationMechanism() {
        return new Supplier<WebAuthnAuthenticationMechanism>(){

            @Override
            public WebAuthnAuthenticationMechanism get() {
                String key;
                if (!((VertxHttpConfig)WebAuthnRecorder.this.httpConfig.getValue()).encryptionKey().isPresent()) {
                    if (encryptionKey != null) {
                        key = encryptionKey;
                    } else {
                        byte[] data = new byte[32];
                        new SecureRandom().nextBytes(data);
                        key = encryptionKey = Base64.getEncoder().encodeToString(data);
                        log.warn((Object)("Encryption key was not specified (using `quarkus.http.auth.session.encryption-key` configuration) for persistent WebAuthn auth, using temporary key " + key));
                    }
                } else {
                    key = (String)((VertxHttpConfig)WebAuthnRecorder.this.httpConfig.getValue()).encryptionKey().get();
                }
                WebAuthnRunTimeConfig config = (WebAuthnRunTimeConfig)WebAuthnRecorder.this.config.getValue();
                PersistentLoginManager loginManager = new PersistentLoginManager(key, config.cookieName(), config.sessionTimeout().toMillis(), config.newCookieInterval().toMillis(), false, config.cookieSameSite().name(), (String)config.cookiePath().orElse(null), config.cookieMaxAge().map(Duration::toSeconds).orElse(-1L).longValue(), null);
                Object loginPage = config.loginPage().startsWith("/") ? config.loginPage() : "/" + config.loginPage();
                return new WebAuthnAuthenticationMechanism(loginManager, (String)loginPage);
            }
        };
    }
}

