/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn;

import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.TrustedAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusPrincipal;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.security.webauthn.WebAuthnSecurity;
import io.quarkus.security.webauthn.WebAuthnUserProvider;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.security.Principal;

@ApplicationScoped
public class WebAuthnTrustedIdentityProvider
implements IdentityProvider<TrustedAuthenticationRequest> {
    @Inject
    WebAuthnSecurity security;
    @Inject
    WebAuthnUserProvider userProvider;

    public Class<TrustedAuthenticationRequest> getRequestType() {
        return TrustedAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(TrustedAuthenticationRequest request, AuthenticationRequestContext context) {
        QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
        builder.setPrincipal((Principal)new QuarkusPrincipal(request.getPrincipal()));
        builder.addRoles(this.userProvider.getRoles(request.getPrincipal()));
        return Uni.createFrom().item((Object)builder.build());
    }
}

