/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn;

import com.webauthn4j.data.AttestationConveyancePreference;
import com.webauthn4j.data.ResidentKeyRequirement;
import com.webauthn4j.data.UserVerificationRequirement;
import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigMapping(prefix="quarkus.webauthn")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface WebAuthnRunTimeConfig {
    @ConfigDocDefault(value="The URI this application is deployed on")
    public Optional<List<String>> origins();

    @ConfigDocDefault(value="USB,NFC,BLE,INTERNAL")
    public Optional<List<AuthenticatorTransport>> transports();

    public RelyingPartyConfig relyingParty();

    public Optional<AuthenticatorAttachment> authenticatorAttachment();

    @ConfigDocDefault(value="false")
    public Optional<Boolean> loadMetadata();

    @ConfigDocDefault(value="REQUIRED")
    public Optional<ResidentKey> residentKey();

    @ConfigDocDefault(value="REQUIRED")
    public Optional<UserVerification> userVerification();

    @ConfigDocDefault(value="true")
    public Optional<Boolean> userPresenceRequired();

    @ConfigDocDefault(value="5m")
    public Optional<Duration> timeout();

    @ConfigDocDefault(value="NONE")
    public Optional<Attestation> attestation();

    @ConfigDocDefault(value="ES256,RS256")
    public Optional<List<COSEAlgorithm>> publicKeyCredentialParameters();

    @ConfigDocDefault(value="64")
    public OptionalInt challengeLength();

    @WithDefault(value="/login.html")
    public String loginPage();

    @WithDefault(value="PT30M")
    public Duration sessionTimeout();

    @WithDefault(value="PT1M")
    public Duration newCookieInterval();

    @WithDefault(value="quarkus-credential")
    public String cookieName();

    @WithDefault(value="_quarkus_webauthn_challenge")
    public String challengeCookieName();

    @WithDefault(value="strict")
    public CookieSameSite cookieSameSite();

    @WithDefault(value="/")
    public Optional<String> cookiePath();

    public Optional<Duration> cookieMaxAge();

    @WithDefault(value="false")
    public Optional<Boolean> enableRegistrationEndpoint();

    @WithDefault(value="false")
    public Optional<Boolean> enableLoginEndpoint();

    @ConfigGroup
    public static interface RelyingPartyConfig {
        @ConfigDocDefault(value="The host name of the first allowed origin, or the host where this application is deployed")
        public Optional<String> id();

        @WithDefault(value="Quarkus server")
        public String name();
    }

    public static enum CookieSameSite {
        STRICT,
        LAX,
        NONE;

    }

    public static enum ResidentKey {
        DISCOURAGED,
        PREFERRED,
        REQUIRED;


        ResidentKeyRequirement toWebAuthn4J() {
            switch (this.ordinal()) {
                case 0: {
                    return ResidentKeyRequirement.DISCOURAGED;
                }
                case 1: {
                    return ResidentKeyRequirement.PREFERRED;
                }
                case 2: {
                    return ResidentKeyRequirement.REQUIRED;
                }
            }
            throw new IllegalStateException("Illegal enum value: " + String.valueOf((Object)this));
        }
    }

    public static enum AuthenticatorTransport {
        USB,
        NFC,
        BLE,
        HYBRID,
        INTERNAL;

    }

    public static enum AuthenticatorAttachment {
        PLATFORM,
        CROSS_PLATFORM;


        com.webauthn4j.data.AuthenticatorAttachment toWebAuthn4J() {
            switch (this.ordinal()) {
                case 1: {
                    return com.webauthn4j.data.AuthenticatorAttachment.CROSS_PLATFORM;
                }
                case 0: {
                    return com.webauthn4j.data.AuthenticatorAttachment.PLATFORM;
                }
            }
            throw new IllegalStateException("Illegal enum value: " + String.valueOf((Object)this));
        }
    }

    public static enum UserVerification {
        REQUIRED,
        PREFERRED,
        DISCOURAGED;


        UserVerificationRequirement toWebAuthn4J() {
            switch (this.ordinal()) {
                case 2: {
                    return UserVerificationRequirement.DISCOURAGED;
                }
                case 1: {
                    return UserVerificationRequirement.PREFERRED;
                }
                case 0: {
                    return UserVerificationRequirement.REQUIRED;
                }
            }
            throw new IllegalStateException("Illegal enum value: " + String.valueOf((Object)this));
        }
    }

    public static enum Attestation {
        NONE,
        INDIRECT,
        DIRECT,
        ENTERPRISE;


        AttestationConveyancePreference toWebAuthn4J() {
            switch (this.ordinal()) {
                case 2: {
                    return AttestationConveyancePreference.DIRECT;
                }
                case 3: {
                    return AttestationConveyancePreference.ENTERPRISE;
                }
                case 1: {
                    return AttestationConveyancePreference.INDIRECT;
                }
                case 0: {
                    return AttestationConveyancePreference.NONE;
                }
            }
            throw new IllegalStateException("Illegal enum value: " + String.valueOf((Object)this));
        }
    }

    public static enum COSEAlgorithm {
        ES256(-7),
        ES384(-35),
        ES512(-36),
        PS256(-37),
        PS384(-38),
        PS512(-39),
        ES256K(-47),
        RS256(-257),
        RS384(-258),
        RS512(-259),
        RS1(-65535),
        EdDSA(-8);

        private final int coseId;

        private COSEAlgorithm(int coseId) {
            this.coseId = coseId;
        }

        public static COSEAlgorithm valueOf(int coseId) {
            switch (coseId) {
                case -7: {
                    return ES256;
                }
                case -35: {
                    return ES384;
                }
                case -36: {
                    return ES512;
                }
                case -37: {
                    return PS256;
                }
                case -38: {
                    return PS384;
                }
                case -39: {
                    return PS512;
                }
                case -47: {
                    return ES256K;
                }
                case -257: {
                    return RS256;
                }
                case -258: {
                    return RS384;
                }
                case -259: {
                    return RS512;
                }
                case -65535: {
                    return RS1;
                }
                case -8: {
                    return EdDSA;
                }
            }
            throw new IllegalArgumentException("Unknown cose-id: " + coseId);
        }

        public int coseId() {
            return this.coseId;
        }
    }
}

