/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn.impl;

import com.webauthn4j.async.metadata.HttpAsyncClient;
import com.webauthn4j.metadata.HttpClient;
import com.webauthn4j.metadata.exception.MDSException;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.auth.impl.http.SimpleHttpClient;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.CompletionStage;

public class VertxHttpAsyncClient
implements HttpAsyncClient {
    private static final byte[] NO_BYTES = new byte[0];
    private SimpleHttpClient httpClient;

    public VertxHttpAsyncClient(Vertx vertx) {
        this.httpClient = new SimpleHttpClient(vertx, "vertx-auth", new HttpClientOptions());
    }

    public CompletionStage<HttpClient.Response> fetch(String uri) throws MDSException {
        return this.httpClient.fetch(HttpMethod.GET, uri, null, null).map(res -> {
            Buffer body = res.body();
            byte[] bytes = body != null ? body.getBytes() : NO_BYTES;
            return new HttpClient.Response(res.statusCode(), (InputStream)new ByteArrayInputStream(bytes));
        }).toCompletionStage();
    }
}

