/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn;

import com.webauthn4j.async.WebAuthnAsyncManager;
import com.webauthn4j.async.anchor.KeyStoreTrustAnchorAsyncRepository;
import com.webauthn4j.async.anchor.TrustAnchorAsyncRepository;
import com.webauthn4j.async.metadata.FidoMDS3MetadataBLOBAsyncProvider;
import com.webauthn4j.async.metadata.HttpAsyncClient;
import com.webauthn4j.async.metadata.MetadataBLOBAsyncProvider;
import com.webauthn4j.async.metadata.anchor.MetadataBLOBBasedTrustAnchorAsyncRepository;
import com.webauthn4j.async.verifier.attestation.statement.androidkey.AndroidKeyAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.androidsafetynet.AndroidSafetyNetAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.apple.AppleAnonymousAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.packed.PackedAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.tpm.TPMAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.u2f.FIDOU2FAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.certpath.CertPathTrustworthinessAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.certpath.DefaultCertPathTrustworthinessAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.self.DefaultSelfAttestationTrustworthinessAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.self.SelfAttestationTrustworthinessAsyncVerifier;
import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticatorSelectionCriteria;
import com.webauthn4j.data.PublicKeyCredentialCreationOptions;
import com.webauthn4j.data.PublicKeyCredentialParameters;
import com.webauthn4j.data.PublicKeyCredentialRequestOptions;
import com.webauthn4j.data.PublicKeyCredentialRpEntity;
import com.webauthn4j.data.PublicKeyCredentialType;
import com.webauthn4j.data.PublicKeyCredentialUserEntity;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.client.challenge.DefaultChallenge;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.Base64UrlUtil;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusPrincipal;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.security.webauthn.WebAuthnAuthenticationMechanism;
import io.quarkus.security.webauthn.WebAuthnAuthenticatorStorage;
import io.quarkus.security.webauthn.WebAuthnCredentialRecord;
import io.quarkus.security.webauthn.WebAuthnLoginResponse;
import io.quarkus.security.webauthn.WebAuthnRegisterResponse;
import io.quarkus.security.webauthn.WebAuthnRunTimeConfig;
import io.quarkus.security.webauthn.impl.VertxHttpAsyncClient;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.vertx.http.runtime.security.PersistentLoginManager;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.CertificateHelper;
import io.vertx.ext.auth.impl.jose.JWS;
import io.vertx.ext.auth.prng.VertxContextPRNG;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@ApplicationScoped
public class WebAuthnSecurity {
    private static final String ANDROID_KEYSTORE_ROOT = "MIICizCCAjKgAwIBAgIJAKIFntEOQ1tXMAoGCCqGSM49BAMCMIGYMQswCQYDVQQGEwJVUzETMBEGA1UECAwKQ2FsaWZvcm5pYTEWMBQGA1UEBwwNTW91bnRhaW4gVmlldzEVMBMGA1UECgwMR29vZ2xlLCBJbmMuMRAwDgYDVQQLDAdBbmRyb2lkMTMwMQYDVQQDDCpBbmRyb2lkIEtleXN0b3JlIFNvZnR3YXJlIEF0dGVzdGF0aW9uIFJvb3QwHhcNMTYwMTExMDA0MzUwWhcNMzYwMTA2MDA0MzUwWjCBmDELMAkGA1UEBhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExFjAUBgNVBAcMDU1vdW50YWluIFZpZXcxFTATBgNVBAoMDEdvb2dsZSwgSW5jLjEQMA4GA1UECwwHQW5kcm9pZDEzMDEGA1UEAwwqQW5kcm9pZCBLZXlzdG9yZSBTb2Z0d2FyZSBBdHRlc3RhdGlvbiBSb290MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAE7l1ex+HA220Dpn7mthvsTWpdamguD/9/SQ59dx9EIm29sa/6FsvHrcV30lacqrewLVQBXT5DKyqO107sSHVBpKNjMGEwHQYDVR0OBBYEFMit6XdMRcOjzw0WEOR5QzohWjDPMB8GA1UdIwQYMBaAFMit6XdMRcOjzw0WEOR5QzohWjDPMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgKEMAoGCCqGSM49BAMCA0cAMEQCIDUho++LNEYenNVg8x1YiSBq3KNlQfYNns6KGYxmSGB7AiBNC/NR2TB8fVvaNTQdqEcbY6WFZTytTySn502vQX3xvw==";
    private static final String GSR1 = "MIIDdTCCAl2gAwIBAgILBAAAAAABFUtaw5QwDQYJKoZIhvcNAQEFBQAwVzELMAkG\nA1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv\nb3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw05ODA5MDExMjAw\nMDBaFw0yODAxMjgxMjAwMDBaMFcxCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i\nYWxTaWduIG52LXNhMRAwDgYDVQQLEwdSb290IENBMRswGQYDVQQDExJHbG9iYWxT\naWduIFJvb3QgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDaDuaZ\njc6j40+Kfvvxi4Mla+pIH/EqsLmVEQS98GPR4mdmzxzdzxtIK+6NiY6arymAZavp\nxy0Sy6scTHAHoT0KMM0VjU/43dSMUBUc71DuxC73/OlS8pF94G3VNTCOXkNz8kHp\n1Wrjsok6Vjk4bwY8iGlbKk3Fp1S4bInMm/k8yuX9ifUSPJJ4ltbcdG6TRGHRjcdG\nsnUOhugZitVtbNV4FpWi6cgKOOvyJBNPc1STE4U6G7weNLWLBYy5d4ux2x8gkasJ\nU26Qzns3dLlwR5EiUWMWea6xrkEmCMgZK9FGqkjWZCrXgzT/LCrBbBlDSgeF59N8\n9iFo7+ryUp9/k5DPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8E\nBTADAQH/MB0GA1UdDgQWBBRge2YaRQ2XyolQL30EzTSo//z9SzANBgkqhkiG9w0B\nAQUFAAOCAQEA1nPnfE920I2/7LqivjTFKDK1fPxsnCwrvQmeU79rXqoRSLblCKOz\nyj1hTdNGCbM+w6DjY1Ub8rrvrTnhQ7k4o+YviiY776BQVvnGCv04zcQLcFGUl5gE\n38NflNUVyRRBnMRddWQVDf9VMOyGj/8N7yy5Y0b2qvzfvGn9LhJIZJrglfCm7ymP\nAbEVtQwdpf5pLGkkeB6zpxxxYu7KyJesF12KwvhHhm4qxFYxldBniYUr+WymXUad\nDKqC5JlR3XC321Y9YeRq4VzW9v493kHMB65jUr9TU/Qr6cf9tveCX4XSQRjbgbME\nHMUfpIBvFSDJ3gyICh3WZlXi/EjJKSZp4A==";
    private static final String APPLE_WEBAUTHN_ROOT_CA = "MIICEjCCAZmgAwIBAgIQaB0BbHo84wIlpQGUKEdXcTAKBggqhkjOPQQDAzBLMR8wHQYDVQQDDBZBcHBsZSBXZWJBdXRobiBSb290IENBMRMwEQYDVQQKDApBcHBsZSBJbmMuMRMwEQYDVQQIDApDYWxpZm9ybmlhMB4XDTIwMDMxODE4MjEzMloXDTQ1MDMxNTAwMDAwMFowSzEfMB0GA1UEAwwWQXBwbGUgV2ViQXV0aG4gUm9vdCBDQTETMBEGA1UECgwKQXBwbGUgSW5jLjETMBEGA1UECAwKQ2FsaWZvcm5pYTB2MBAGByqGSM49AgEGBSuBBAAiA2IABCJCQ2pTVhzjl4Wo6IhHtMSAzO2cv+H9DQKev3//fG59G11kxu9eI0/7o6V5uShBpe1u6l6mS19S1FEh6yGljnZAJ+2GNP1mi/YK2kSXIuTHjxA/pcoRf7XkOtO4o1qlcaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUJtdk2cV4wlpn0afeaxLQG2PxxtcwDgYDVR0PAQH/BAQDAgEGMAoGCCqGSM49BAMDA2cAMGQCMFrZ+9DsJ1PW9hfNdBywZDsWDbWFp28it1d/5w2RPkRX3Bbn/UbDTNLx7Jr3jAGGiQIwHFj+dJZYUJR786osByBelJYsVZd2GbHQu209b5RCmGQ21gpSAk9QZW4B1bWeT0vT";
    private static final String FIDO_MDS3_ROOT_CERTIFICATE = "MIIDXzCCAkegAwIBAgILBAAAAAABIVhTCKIwDQYJKoZIhvcNAQELBQAwTDEgMB4GA1UECxMXR2xvYmFsU2lnbiBSb290IENBIC0gUjMxEzARBgNVBAoTCkdsb2JhbFNpZ24xEzARBgNVBAMTCkdsb2JhbFNpZ24wHhcNMDkwMzE4MTAwMDAwWhcNMjkwMzE4MTAwMDAwWjBMMSAwHgYDVQQLExdHbG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEGA1UEChMKR2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMwldpB5BngiFvXAg7aEyiie/QV2EcWtiHL8RgJDx7KKnQRfJMsuS+FggkbhUqsMgUdwbN1k0ev1LKMPgj0MK66X17YUhhB5uzsTgHeMCOFJ0mpiLx9e+pZo34knlTifBtc+ycsmWQ1z3rDI6SYOgxXG71uL0gRgykmmKPZpO/bLyCiR5Z2KYVc3rHQU3HTgOu5yLy6c+9C7v/U9AOEGM+iCK65TpjoWc4zdQQ4gOsC0p6Hpsk+QLjJg6VfLuQSSaGjlOCZgdbKfd/+RFO+uIEn8rUAVSNECMWEZXriX7613t2Saer9fwRPvm2L7DWzgVGkWqQPabumDk3F2xmmFghcCAwEAAaNCMEAwDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFI/wS3+oLkUkrk1Q+mOai97i3Ru8MA0GCSqGSIb3DQEBCwUAA4IBAQBLQNvAUKr+yAzv95ZURUm7lgAJQayzE4aGKAczymvmdLm6AC2upArT9fHxD4q/c2dKg8dEe3jgr25sbwMpjjM5RcOO5LlXbKr8EpbsU8Yt5CRsuZRj+9xTaGdWPoO4zzUhw8lo/s7awlOqzJCK6fBdRoyV3XpYKBovHd7NADdBj+1EbddTKJd+82cEHhXXipa0095MJ6RMG3NzdvQXmcIfeg7jLQitChws/zyrVQ4PkX4268NXSb7hLi18YIvDQVETI53O9zJrlAGomecsMx86OyXShkDOOyyGeMlhLxS67ttVb9+E7gUJTb0o2HLO02JQZR7rkpeDMdmztcpHWD9f";
    @Inject
    TlsConfigurationRegistry certificates;
    @Inject
    WebAuthnAuthenticationMechanism authMech;
    @Inject
    WebAuthnAuthenticatorStorage storage;
    private ObjectConverter objectConverter = new ObjectConverter();
    private WebAuthnAsyncManager webAuthn;
    private VertxContextPRNG random;
    private String challengeCookie;
    private List<String> origins;
    private String rpId;
    private String rpName;
    private WebAuthnRunTimeConfig.UserVerification userVerification;
    private Boolean userPresenceRequired;
    private List<PublicKeyCredentialParameters> pubKeyCredParams;
    private WebAuthnRunTimeConfig.ResidentKey residentKey;
    private Duration timeout;
    private int challengeLength;
    private WebAuthnRunTimeConfig.AuthenticatorAttachment authenticatorAttachment;
    private WebAuthnRunTimeConfig.Attestation attestation;

    public WebAuthnSecurity(WebAuthnRunTimeConfig config, Vertx vertx, WebAuthnAuthenticatorStorage database) {
        this.rpId = config.relyingParty().id().orElse(null);
        this.rpName = config.relyingParty().name();
        this.origins = config.origins().orElse(Collections.emptyList());
        this.challengeCookie = config.challengeCookieName();
        this.challengeLength = config.challengeLength().orElse(64);
        this.userPresenceRequired = config.userPresenceRequired().orElse(true);
        this.timeout = config.timeout().orElse(Duration.ofMinutes(5L));
        if (config.publicKeyCredentialParameters().isPresent()) {
            this.pubKeyCredParams = new ArrayList<PublicKeyCredentialParameters>(config.publicKeyCredentialParameters().get().size());
            for (WebAuthnRunTimeConfig.COSEAlgorithm publicKeyCredential : config.publicKeyCredentialParameters().get()) {
                this.pubKeyCredParams.add(new PublicKeyCredentialParameters(PublicKeyCredentialType.PUBLIC_KEY, COSEAlgorithmIdentifier.create((long)publicKeyCredential.coseId())));
            }
        } else {
            this.pubKeyCredParams = new ArrayList<PublicKeyCredentialParameters>(2);
            this.pubKeyCredParams.add(new PublicKeyCredentialParameters(PublicKeyCredentialType.PUBLIC_KEY, COSEAlgorithmIdentifier.ES256));
            this.pubKeyCredParams.add(new PublicKeyCredentialParameters(PublicKeyCredentialType.PUBLIC_KEY, COSEAlgorithmIdentifier.RS256));
        }
        this.authenticatorAttachment = config.authenticatorAttachment().orElse(null);
        this.userVerification = config.userVerification().orElse(WebAuthnRunTimeConfig.UserVerification.REQUIRED);
        this.residentKey = config.residentKey().orElse(WebAuthnRunTimeConfig.ResidentKey.REQUIRED);
        this.attestation = config.attestation().orElse(WebAuthnRunTimeConfig.Attestation.NONE);
        this.webAuthn = this.makeWebAuthn(vertx, config);
        this.random = VertxContextPRNG.current((Vertx)vertx);
    }

    private String randomBase64URLBuffer() {
        byte[] buff = new byte[this.challengeLength];
        this.random.nextBytes(buff);
        return Base64UrlUtil.encodeToString((byte[])buff);
    }

    private WebAuthnAsyncManager makeWebAuthn(Vertx vertx, WebAuthnRunTimeConfig config) {
        if (config.attestation().isPresent() && config.attestation().get() != WebAuthnRunTimeConfig.Attestation.NONE) {
            KeyStore trustStore;
            Optional webauthnTlsConfiguration = this.certificates.get("webauthn");
            if (webauthnTlsConfiguration.isPresent()) {
                trustStore = ((TlsConfiguration)webauthnTlsConfiguration.get()).getTrustStore();
            } else {
                try {
                    trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    trustStore.load(null, null);
                    this.addCert(trustStore, ANDROID_KEYSTORE_ROOT);
                    this.addCert(trustStore, APPLE_WEBAUTHN_ROOT_CA);
                    this.addCert(trustStore, FIDO_MDS3_ROOT_CERTIFICATE);
                    this.addCert(trustStore, GSR1);
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    throw new RuntimeException("Failed to configure default WebAuthn certificates", e);
                }
            }
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            try {
                Enumeration<String> aliases = trustStore.aliases();
                while (aliases.hasMoreElements()) {
                    trustAnchors.add(new TrustAnchor((X509Certificate)trustStore.getCertificate(aliases.nextElement()), null));
                }
            }
            catch (KeyStoreException e) {
                throw new RuntimeException("Failed to configure WebAuthn trust store", e);
            }
            KeyStoreTrustAnchorAsyncRepository something = new KeyStoreTrustAnchorAsyncRepository(trustStore);
            if (config.loadMetadata().orElse(false).booleanValue()) {
                VertxHttpAsyncClient httpClient = new VertxHttpAsyncClient(vertx);
                FidoMDS3MetadataBLOBAsyncProvider blobAsyncProvider = new FidoMDS3MetadataBLOBAsyncProvider(this.objectConverter, "https://mds.fidoalliance.org/", (HttpAsyncClient)httpClient, trustAnchors);
                something = new MetadataBLOBBasedTrustAnchorAsyncRepository(new MetadataBLOBAsyncProvider[]{blobAsyncProvider});
            }
            return new WebAuthnAsyncManager(Arrays.asList(new FIDOU2FAttestationStatementAsyncVerifier(), new PackedAttestationStatementAsyncVerifier(), new TPMAttestationStatementAsyncVerifier(), new AndroidKeyAttestationStatementAsyncVerifier(), new AndroidSafetyNetAttestationStatementAsyncVerifier(), new AppleAnonymousAttestationStatementAsyncVerifier()), (CertPathTrustworthinessAsyncVerifier)new DefaultCertPathTrustworthinessAsyncVerifier((TrustAnchorAsyncRepository)something), (SelfAttestationTrustworthinessAsyncVerifier)new DefaultSelfAttestationTrustworthinessAsyncVerifier(), this.objectConverter);
        }
        return WebAuthnAsyncManager.createNonStrictWebAuthnAsyncManager((ObjectConverter)this.objectConverter);
    }

    private void addCert(KeyStore keyStore, String pemCertificate) throws CertificateException, KeyStoreException {
        X509Certificate cert = JWS.parseX5c((String)pemCertificate);
        CertificateHelper.CertInfo info = CertificateHelper.getCertInfo((X509Certificate)cert);
        keyStore.setCertificateEntry(info.subject("CN"), cert);
    }

    private static byte[] uUIDBytes(UUID uuid) {
        Buffer buffer = Buffer.buffer((int)16);
        buffer.setLong(0, uuid.getMostSignificantBits());
        buffer.setLong(8, uuid.getLeastSignificantBits());
        return buffer.getBytes();
    }

    public Uni<PublicKeyCredentialCreationOptions> getRegisterChallenge(String username, String displayName, RoutingContext ctx) {
        if (username == null || username.isEmpty()) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("Username is required"));
        }
        if (displayName == null || displayName.isEmpty()) {
            displayName = username;
        }
        String finalDisplayName = displayName;
        String challenge = this.getOrCreateChallenge(ctx);
        Origin origin = Origin.create((String)(!this.origins.isEmpty() ? this.origins.get(0) : ctx.request().absoluteURI()));
        String rpId = this.rpId != null ? this.rpId : origin.getHost();
        return this.storage.findByUsername(username).map(credentials -> {
            List excluded = Collections.emptyList();
            PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions = new PublicKeyCredentialCreationOptions(new PublicKeyCredentialRpEntity(rpId, this.rpName), new PublicKeyCredentialUserEntity(WebAuthnSecurity.uUIDBytes(UUID.randomUUID()), username, finalDisplayName), (Challenge)new DefaultChallenge(challenge), this.pubKeyCredParams, Long.valueOf(this.timeout.getSeconds() * 1000L), excluded, new AuthenticatorSelectionCriteria(this.authenticatorAttachment != null ? this.authenticatorAttachment.toWebAuthn4J() : null, Boolean.valueOf(this.residentKey == WebAuthnRunTimeConfig.ResidentKey.REQUIRED), this.residentKey.toWebAuthn4J(), this.userVerification.toWebAuthn4J()), this.attestation.toWebAuthn4J(), new AuthenticationExtensionsClientInputs());
            this.authMech.getLoginManager().save(challenge, ctx, this.challengeCookie, null, ctx.request().isSSL());
            return publicKeyCredentialCreationOptions;
        });
    }

    public Uni<PublicKeyCredentialRequestOptions> getLoginChallenge(String username, RoutingContext ctx) {
        if (username == null) {
            username = "";
        }
        String finalUsername = username;
        String challenge = this.getOrCreateChallenge(ctx);
        Origin origin = Origin.create((String)(!this.origins.isEmpty() ? this.origins.get(0) : ctx.request().absoluteURI()));
        String rpId = this.rpId != null ? this.rpId : origin.getHost();
        Uni<List<WebAuthnCredentialRecord>> credentialsUni = username.isEmpty() ? Uni.createFrom().item(Collections.emptyList()) : this.storage.findByUsername(username);
        return credentialsUni.map(credentials -> {
            List allowedCredentials = Collections.emptyList();
            PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions = new PublicKeyCredentialRequestOptions((Challenge)new DefaultChallenge(challenge), Long.valueOf(this.timeout.getSeconds() * 1000L), rpId, allowedCredentials, this.userVerification.toWebAuthn4J(), null);
            this.authMech.getLoginManager().save(challenge, ctx, this.challengeCookie, null, ctx.request().isSSL());
            return publicKeyCredentialRequestOptions;
        });
    }

    private String getOrCreateChallenge(RoutingContext ctx) {
        PersistentLoginManager.RestoreResult challengeRestoreResult = this.authMech.getLoginManager().restore(ctx, this.challengeCookie);
        String challenge = challengeRestoreResult == null || challengeRestoreResult.getPrincipal() == null || challengeRestoreResult.getPrincipal().isEmpty() ? this.randomBase64URLBuffer() : challengeRestoreResult.getPrincipal();
        return challenge;
    }

    public Uni<WebAuthnCredentialRecord> register(String username, WebAuthnRegisterResponse response, RoutingContext ctx) {
        return this.register(username, response.toJsonObject(), ctx);
    }

    public Uni<WebAuthnCredentialRecord> register(String username, JsonObject response, RoutingContext ctx) {
        PersistentLoginManager.RestoreResult challenge = this.authMech.getLoginManager().restore(ctx, this.challengeCookie);
        if (challenge == null || challenge.getPrincipal() == null || challenge.getPrincipal().isEmpty()) {
            return Uni.createFrom().failure((Throwable)new RuntimeException("Missing challenge"));
        }
        if (username == null || username.isEmpty()) {
            return Uni.createFrom().failure((Throwable)new RuntimeException("Missing username"));
        }
        if (!(response != null && WebAuthnSecurity.containsRequiredString(response, "id") && WebAuthnSecurity.containsRequiredString(response, "rawId") && WebAuthnSecurity.containsRequiredObject(response, "response") && WebAuthnSecurity.containsOptionalString(response.getJsonObject("response"), "userHandle") && WebAuthnSecurity.containsRequiredString(response, "type") && "public-key".equals(response.getString("type")))) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("Response missing one or more of id/rawId/response[.userHandle]/type fields, or type is not public-key"));
        }
        String registrationResponseJSON = response.encode();
        ServerProperty serverProperty = this.makeServerProperty(challenge, ctx);
        RegistrationParameters registrationParameters = new RegistrationParameters(serverProperty, this.pubKeyCredParams, this.userVerification == WebAuthnRunTimeConfig.UserVerification.REQUIRED, this.userPresenceRequired.booleanValue());
        return Uni.createFrom().completionStage(this.webAuthn.verifyRegistrationResponseJSON(registrationResponseJSON, registrationParameters)).eventually(() -> WebAuthnSecurity.removeCookie(ctx, this.challengeCookie)).map(registrationData -> new WebAuthnCredentialRecord(username, registrationData.getAttestationObject(), registrationData.getCollectedClientData(), (AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput>)registrationData.getClientExtensions(), registrationData.getTransports()));
    }

    private ServerProperty makeServerProperty(PersistentLoginManager.RestoreResult challenge, RoutingContext ctx) {
        HashSet<Origin> origins = new HashSet<Origin>();
        Origin firstOrigin = null;
        if (this.origins.isEmpty()) {
            firstOrigin = Origin.create((String)ctx.request().absoluteURI());
            origins.add(firstOrigin);
        } else {
            for (String origin : this.origins) {
                Origin newOrigin = Origin.create((String)origin);
                if (firstOrigin != null) continue;
                firstOrigin = newOrigin;
                origins.add(newOrigin);
            }
        }
        String rpId = this.rpId != null ? this.rpId : firstOrigin.getHost();
        DefaultChallenge challengeObject = new DefaultChallenge(challenge.getPrincipal());
        return new ServerProperty(origins, rpId, (Challenge)challengeObject, null);
    }

    public Uni<WebAuthnCredentialRecord> login(WebAuthnLoginResponse response, RoutingContext ctx) {
        return this.login(response.toJsonObject(), ctx);
    }

    public Uni<WebAuthnCredentialRecord> login(JsonObject response, RoutingContext ctx) {
        PersistentLoginManager.RestoreResult challenge = this.authMech.getLoginManager().restore(ctx, this.challengeCookie);
        if (challenge == null || challenge.getPrincipal() == null || challenge.getPrincipal().isEmpty()) {
            return Uni.createFrom().failure((Throwable)new RuntimeException("Missing challenge"));
        }
        if (!(response != null && WebAuthnSecurity.containsRequiredString(response, "id") && WebAuthnSecurity.containsRequiredString(response, "rawId") && WebAuthnSecurity.containsRequiredObject(response, "response") && WebAuthnSecurity.containsOptionalString(response.getJsonObject("response"), "userHandle") && WebAuthnSecurity.containsRequiredString(response, "type") && "public-key".equals(response.getString("type")))) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("Response missing one or more of id/rawId/response[.userHandle]/type fields, or type is not public-key"));
        }
        String authenticationResponseJSON = response.encode();
        String rawId = response.getString("rawId");
        ServerProperty serverProperty = this.makeServerProperty(challenge, ctx);
        return this.storage.findByCredID(rawId).chain(credentialRecord -> {
            List<byte[]> allowCredentials = List.of(Base64UrlUtil.decode((String)rawId));
            AuthenticationParameters authenticationParameters = new AuthenticationParameters(serverProperty, (Authenticator)credentialRecord, allowCredentials, this.userVerification == WebAuthnRunTimeConfig.UserVerification.REQUIRED, this.userPresenceRequired.booleanValue());
            return Uni.createFrom().completionStage(this.webAuthn.verifyAuthenticationResponseJSON(authenticationResponseJSON, authenticationParameters)).eventually(() -> WebAuthnSecurity.removeCookie(ctx, this.challengeCookie)).map(authenticationData -> credentialRecord);
        });
    }

    static void removeCookie(RoutingContext ctx, String name) {
        Cookie cookie = ctx.request().getCookie(name);
        if (cookie != null) {
            cookie.setPath("/");
        }
        ctx.response().removeCookie(name);
    }

    public WebAuthnAsyncManager getWebAuthn4J() {
        return this.webAuthn;
    }

    public void rememberUser(String userID, RoutingContext ctx) {
        QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
        builder.setPrincipal((Principal)new QuarkusPrincipal(userID));
        this.authMech.getLoginManager().save((SecurityIdentity)builder.build(), ctx, null, ctx.request().isSSL());
    }

    public void logout(RoutingContext ctx) {
        this.authMech.getLoginManager().clear(ctx);
    }

    static boolean containsRequiredString(JsonObject json, String key) {
        try {
            if (json == null) {
                return false;
            }
            if (!json.containsKey(key)) {
                return false;
            }
            Object s = json.getValue(key);
            return s instanceof String && !"".equals(s);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private static boolean containsOptionalString(JsonObject json, String key) {
        try {
            if (json == null) {
                return true;
            }
            if (!json.containsKey(key)) {
                return true;
            }
            Object s = json.getValue(key);
            return s instanceof String;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private static boolean containsRequiredObject(JsonObject json, String key) {
        try {
            if (json == null) {
                return false;
            }
            if (!json.containsKey(key)) {
                return false;
            }
            JsonObject s = json.getJsonObject(key);
            return s != null;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toJsonString(PublicKeyCredentialCreationOptions challenge) {
        return this.objectConverter.getJsonConverter().writeValueAsString((Object)challenge);
    }

    public String toJsonString(PublicKeyCredentialRequestOptions challenge) {
        return this.objectConverter.getJsonConverter().writeValueAsString((Object)challenge);
    }

    public List<String> getAllowedOrigins(RoutingContext ctx) {
        if (this.origins.isEmpty()) {
            return List.of(Origin.create((String)ctx.request().absoluteURI()).toString());
        }
        return this.origins;
    }

    WebAuthnAuthenticatorStorage storage() {
        return this.storage;
    }
}

